import React from 'react';
import PropTypes from 'prop-types';

/**
 * StatusBadge Component
 * Reusable badge component for displaying status with color coding
 */
const StatusBadge = ({ 
    children, 
    variant = 'default', 
    size = 'sm',
    className = '' 
}) => {
    // Variant color schemes
    const variantStyles = {
        success: 'bg-green-100 text-green-800 border-green-200',
        warning: 'bg-yellow-100 text-yellow-800 border-yellow-200',
        danger: 'bg-red-100 text-red-800 border-red-200',
        info: 'bg-blue-100 text-blue-800 border-blue-200',
        purple: 'bg-purple-100 text-purple-800 border-purple-200',
        orange: 'bg-orange-100 text-orange-800 border-orange-200',
        default: 'bg-gray-100 text-gray-800 border-gray-200',
    };

    // Size styles
    const sizeStyles = {
        xs: 'px-2 py-0.5 text-xs',
        sm: 'px-2.5 py-1 text-xs',
        md: 'px-3 py-1.5 text-sm',
        lg: 'px-4 py-2 text-base',
    };

    const baseStyles = 'inline-flex items-center font-medium rounded-full border';

    return (
        <span 
            className={`
                ${baseStyles}
                ${variantStyles[variant] || variantStyles.default}
                ${sizeStyles[size] || sizeStyles.sm}
                ${className}
            `}
        >
            {children}
        </span>
    );
};

StatusBadge.propTypes = {
    children: PropTypes.node.isRequired,
    variant: PropTypes.oneOf(['success', 'warning', 'danger', 'info', 'purple', 'orange', 'default']),
    size: PropTypes.oneOf(['xs', 'sm', 'md', 'lg']),
    className: PropTypes.string,
};

export default StatusBadge;




