import React from "react";
import { Link } from "@inertiajs/react";
import { User, CheckCircle, AlertCircle, ChevronRight } from "lucide-react";

export default function ProfileCompletionCard({
    profile,
    percentage,
    missingFields,
    isQualified,
}) {
    // Support both old and new API styles
    const completionPercentage =
        percentage || profile?.profile_completion_percentage || 0;
    const missingRequiredFields =
        missingFields || profile?.missing_required_fields || [];

    // Determine color based on completion percentage
    const getColorClass = () => {
        if (completionPercentage >= 80) return "bg-green-500";
        if (completionPercentage >= 50) return "bg-yellow-500";
        return "bg-red-500";
    };

    return (
        <div className="bg-gradient-to-r from-blue-100 to-cyan-100 dark:bg-none border border-gray-300 dark:border-gray-600 dark:bg-gray-800 rounded-lg shadow-sm p-4">
            <div className="flex items-center justify-between mb-4">
                <h3 className="text-lg font-medium text-gray-900 dark:text-white flex items-center">
                    <User className="w-5 h-5 mr-2 text-blue-600 dark:text-blue-400" />
                    Profile Completion
                </h3>
                <span
                    className={`px-2 py-1 text-xs font-bold rounded-full text-white ${getColorClass()}`}
                >
                    {completionPercentage}%
                </span>
            </div>

            <div className="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2.5 mb-4">
                <div
                    className={`h-2.5 rounded-full ${getColorClass()}`}
                    style={{ width: `${completionPercentage}%` }}
                ></div>
            </div>

            {missingRequiredFields.length > 0 ? (
                <>
                    <div className="mb-4">
                        <div className="flex items-start text-amber-600 dark:text-amber-400">
                            <AlertCircle className="w-5 h-5 mr-2 flex-shrink-0" />
                            <p className="text-sm">
                                Complete your profile to increase your chances
                                of getting orders.
                            </p>
                        </div>
                    </div>

                    <div className="mb-4">
                        <h4 className="text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Missing information:
                        </h4>
                        <ul className="text-sm text-gray-600 dark:text-gray-400 space-y-1 pl-5 list-disc">
                            {missingRequiredFields.map((field, index) => (
                                <li key={index}>{field}</li>
                            ))}
                        </ul>
                    </div>
                </>
            ) : (
                <div className="mb-4">
                    <div className="flex items-start text-green-600 dark:text-green-400">
                        <CheckCircle className="w-5 h-5 mr-2 flex-shrink-0" />
                        <p className="text-sm">
                            Your profile is complete! This will help you win
                            more bids.
                        </p>
                    </div>
                </div>
            )}

            <Link
                href={route("writer.profile.edit")}
                className={`w-full flex items-center justify-center px-4 py-2 ${
                    isQualified
                        ? "bg-blue-600 hover:bg-blue-700 focus:bg-blue-700"
                        : "bg-gray-600 hover:bg-gray-700 focus:bg-gray-700"
                } text-white rounded-md transition-colors duration-150 ease-in-out`}
                disabled={!isQualified}
            >
                {isQualified ? (
                    <>
                        Update Your Profile
                        <ChevronRight className="ml-1 w-4 h-4" />
                    </>
                ) : (
                    <>
                        Complete qualification tests first
                        <ChevronRight className="ml-1 w-4 h-4" />
                    </>
                )}
            </Link>
        </div>
    );
}
