import React from 'react';

export default function ClientBenefits({ title, description, benefits }) {
    if (!benefits || benefits.length === 0) return null;

    return (
        <section className="py-16 bg-gray-50 dark:bg-gray-800">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 dark:text-gray-300 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    {benefits.map((benefit, index) => (
                        <div
                            key={index}
                            className="bg-white dark:bg-gray-900 rounded-lg shadow-lg p-8 hover:shadow-xl transition-all"
                        >
                            <div className="text-5xl mb-4 text-center">{benefit.icon}</div>
                            <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-2 text-center">
                                {benefit.title}
                            </h3>
                            {benefit.subtitle && (
                                <p className="text-gray-600 dark:text-gray-400 mb-4 text-center italic text-sm">
                                    {benefit.subtitle}
                                </p>
                            )}
                            <div 
                                className="text-gray-600 dark:text-gray-300 mb-6 content-area"
                                dangerouslySetInnerHTML={{ __html: benefit.description }}
                            />

                            {benefit.features && benefit.features.length > 0 && (
                                <ul className="space-y-2">
                                    {benefit.features.map((feature, idx) => (
                                        <li key={idx} className="flex items-start">
                                            <span className="text-green-500 dark:text-green-400 mr-2">✓</span>
                                            <span className="text-gray-700 dark:text-gray-300 text-sm">{feature}</span>
                                        </li>
                                    ))}
                                </ul>
                            )}
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}




