import React from 'react';

export default function QualityControl({ title, description, features, stats }) {
    if (!features || features.length === 0) return null;

    return (
        <section className="py-16 bg-white dark:bg-gray-900">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                    {/* Left: Content */}
                    <div>
                        {title && (
                            <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-6">
                                {title}
                            </h2>
                        )}
                        {description && (
                            <div 
                                className="text-xl text-gray-600 dark:text-gray-300 mb-8 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}

                        <div className="space-y-6">
                            {features.map((feature, index) => (
                                <div key={index} className="border-l-4 border-blue-500 dark:border-blue-400 pl-6">
                                    <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-2">
                                        <span className="text-2xl mr-2">{feature.icon}</span>
                                        {feature.title}
                                    </h3>
                                    {feature.subtitle && (
                                        <p className="text-gray-600 dark:text-gray-400 mb-2 italic">
                                            {feature.subtitle}
                                        </p>
                                    )}
                                    <div 
                                        className="text-gray-700 dark:text-gray-300 mb-3 content-area"
                                        dangerouslySetInnerHTML={{ __html: feature.description }}
                                    />

                                    {(feature.metrics || feature.support || feature.services) && (
                                        <ul className="space-y-1 text-sm">
                                            {(feature.metrics || feature.support || feature.services).map((item, idx) => (
                                                <li key={idx} className="text-gray-600 dark:text-gray-400">
                                                    • {item}
                                                </li>
                                            ))}
                                        </ul>
                                    )}
                                </div>
                            ))}
                        </div>
                    </div>

                    {/* Right: Stats Cards */}
                    {stats && stats.length > 0 && (
                        <div className="bg-blue-50 dark:bg-gray-800 rounded-lg p-8">
                            <h3 className="text-2xl font-bold text-gray-900 dark:text-white mb-6 text-center">
                                Quality Performance Metrics
                            </h3>
                            <div className="grid grid-cols-2 gap-6">
                                {stats.map((stat, index) => (
                                    <div key={index} className="text-center">
                                        <div className="text-4xl font-bold text-blue-600 dark:text-blue-400 mb-2">
                                            {stat.value}
                                        </div>
                                        <div className="text-gray-700 dark:text-gray-300 text-sm">
                                            {stat.label}
                                        </div>
                                    </div>
                                ))}
                            </div>
                        </div>
                    )}
                </div>
            </div>
        </section>
    );
}




