import React from 'react';

export default function WriterHero({ hero, stats }) {
    if (!hero) return null;

    return (
        <section className="bg-gradient-to-r from-blue-600 to-indigo-700 dark:from-blue-800 dark:to-indigo-900 text-white py-16">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                <div className="text-center">
                    <h1 className="text-4xl md:text-5xl font-bold mb-6">
                        {hero.title}
                    </h1>
                    <div 
                        className="text-xl md:text-2xl mb-8 max-w-3xl mx-auto content-area text-blue-50"
                        dangerouslySetInnerHTML={{ __html: hero.description }}
                    />

                    {/* Writer Stats */}
                    {stats && stats.length > 0 && (
                        <div className="grid grid-cols-2 md:grid-cols-4 gap-6 max-w-5xl mx-auto">
                            {stats.map((stat, index) => (
                                <div key={index} className="text-center bg-white/10 dark:bg-gray-800/30 rounded-lg p-4 backdrop-blur-sm">
                                    <div className="text-3xl font-bold mb-2">
                                        {stat.value}
                                    </div>
                                    <div className="text-blue-100 dark:text-blue-200 text-sm">
                                        {stat.label}
                                    </div>
                                </div>
                            ))}
                        </div>
                    )}
                </div>
            </div>
        </section>
    );
}




