import React from 'react';

export default function WriterSuperpowers({ title, description, superpowers }) {
    if (!superpowers || superpowers.length === 0) return null;

    return (
        <section className="py-16 bg-gray-50 dark:bg-gray-800">
            <div className="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
                {title && (
                    <div className="text-center mb-12">
                        <h2 className="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                            {title}
                        </h2>
                        {description && (
                            <div 
                                className="text-xl text-gray-600 dark:text-gray-300 content-area"
                                dangerouslySetInnerHTML={{ __html: description }}
                            />
                        )}
                    </div>
                )}

                <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
                    {superpowers.map((superpower, index) => (
                        <div
                            key={index}
                            className="bg-white dark:bg-gray-900 rounded-lg shadow-lg p-8 hover:shadow-xl transition-shadow"
                        >
                            <div className="text-5xl mb-6 text-center">{superpower.icon}</div>
                            <h3 className="text-xl font-bold text-gray-900 dark:text-white mb-4 text-center">
                                {superpower.title}
                            </h3>
                            <div 
                                className="text-gray-600 dark:text-gray-300 mb-6 content-area"
                                dangerouslySetInnerHTML={{ __html: superpower.description }}
                            />

                            {superpower.benefits && superpower.benefits.length > 0 && (
                                <ul className="space-y-2">
                                    {superpower.benefits.map((benefit, idx) => (
                                        <li key={idx} className="flex items-start">
                                            <svg
                                                className="w-5 h-5 text-green-500 dark:text-green-400 mr-2 mt-1 flex-shrink-0"
                                                fill="currentColor"
                                                viewBox="0 0 20 20"
                                            >
                                                <path
                                                    fillRule="evenodd"
                                                    d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z"
                                                    clipRule="evenodd"
                                                />
                                            </svg>
                                            <span className="text-gray-700 dark:text-gray-300">{benefit}</span>
                                        </li>
                                    ))}
                                </ul>
                            )}
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}




