// export function Button({ className = "", disabled, children, ...props }) {
//     return (
//         <button
//             className={`inline-flex items-center justify-center rounded-md bg-gray-700 px-4 py-2 text-sm
//             font-medium text-gray-100 hover:bg-gray-600 focus:outline-none focus:ring-2
//             focus:ring-gray-600 disabled:opacity-50 ${className}`}
//             disabled={disabled}
//             {...props}
//         >
//             {children}
//         </button>
//     );
// }

import * as React from "react";
import { Link } from "@inertiajs/react";
import { cn } from "@/lib/utils";

const Button = React.forwardRef(
    ({ className, variant, size, asChild, href, ...props }, ref) => {
        const variantStyles = {
            default:
                "bg-blue-600 text-white hover:bg-blue-700 focus:ring-blue-500 dark:bg-blue-500 dark:hover:bg-blue-600",
            destructive:
                "bg-red-600 text-white hover:bg-red-700 focus:ring-red-500 dark:bg-red-600 dark:hover:bg-red-700",
            outline:
                "bg-transparent border border-gray-300 text-gray-700 hover:bg-gray-50 focus:ring-blue-500 dark:border-gray-600 dark:text-gray-200 dark:hover:bg-gray-700/50",
            secondary:
                "bg-gray-200 text-gray-900 hover:bg-gray-300 focus:ring-gray-500 dark:bg-gray-700 dark:text-gray-100 dark:hover:bg-gray-600",
            ghost: "bg-transparent text-gray-700 hover:bg-gray-100 focus:ring-gray-500 dark:text-gray-200 dark:hover:bg-gray-800",
            link: "bg-transparent text-blue-600 hover:underline focus:ring-blue-500 dark:text-blue-400 dark:hover:bg-transparent p-0",
        };

        const sizeStyles = {
            default: "h-10 px-4 py-2",
            sm: "h-8 px-3 py-1 text-sm",
            lg: "h-12 px-6 py-3 text-lg",
            xl: "h-14 px-8 py-4 text-xl",
            icon: "h-10 w-10 p-2",
            "icon-sm": "h-8 w-8 p-1.5",
            none: "",
        };

        const classes = cn(
            "inline-flex items-center justify-center font-medium rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 dark:focus:ring-offset-gray-900 transition-colors disabled:opacity-50 disabled:pointer-events-none",
            variantStyles[variant] || variantStyles.default,
            sizeStyles[size] || sizeStyles.default,
            className
        );

        // If asChild is true and href is provided, render a Link
        if (asChild && href) {
            return (
                <Link href={href} className={classes} ref={ref} {...props} />
            );
        }

        // If href is provided but not asChild, render an anchor element
        if (href) {
            return <a href={href} className={classes} ref={ref} {...props} />;
        }

        // Otherwise render a button
        return <button className={classes} ref={ref} {...props} />;
    }
);

Button.displayName = "Button";

export { Button };
