import * as React from "react";
import { cn } from "@/lib/utils";
import { Check } from "lucide-react";

const Checkbox = React.forwardRef(
    (
        {
            className,
            checked,
            defaultChecked,
            onChange,
            onCheckedChange, // Add this to the destructured props
            disabled,
            id,
            name,
            value,
            ...props
        },
        ref
    ) => {
        const [isChecked, setIsChecked] = React.useState(
            defaultChecked || false
        );

        React.useEffect(() => {
            if (checked !== undefined) {
                setIsChecked(checked);
            }
        }, [checked]);

        const handleChange = (e) => {
            if (checked === undefined) {
                setIsChecked(e.target.checked);
            }

            // Call both onChange and onCheckedChange if they exist
            if (onChange) {
                onChange(e);
            }

            // Map onCheckedChange to receive the checked state directly
            if (onCheckedChange) {
                onCheckedChange(e.target.checked);
            }
        };

        return (
            <div className="relative inline-flex items-center">
                <input
                    type="checkbox"
                    ref={ref}
                    id={id}
                    name={name}
                    value={value}
                    checked={isChecked}
                    onChange={handleChange}
                    disabled={disabled}
                    className={cn(
                        "peer h-4 w-4 appearance-none rounded border border-gray-300 bg-white",
                        "checked:border-blue-500 checked:bg-blue-500 dark:border-gray-600 dark:bg-gray-700",
                        "focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800",
                        "disabled:cursor-not-allowed disabled:opacity-50",
                        className
                    )}
                    {...props}
                />
                <Check className="absolute h-3 w-3 text-white opacity-0 peer-checked:opacity-100 pointer-events-none" />
            </div>
        );
    }
);

Checkbox.displayName = "Checkbox";

export { Checkbox };
