import { Label } from "@/Components/ui/Label";
export const CustomSelect = ({
    id,
    label,
    value,
    setData,
    name,
    options = [], // Default to an empty array
    error,
    placeholder = "Select an option",
    required,
}) => {
    return (
        <div>
            <Label htmlFor={id}>{label}</Label>
            <select
                id={id}
                value={value}
                onChange={(e) => setData(name, e.target.value)}
                className="mt-1 block w-full rounded-md border border-gray-700 bg-gray-800 px-3 py-2 text-gray-100 focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                required={required}
            >
                <option value="" disabled>
                    {placeholder}
                </option>
                {options.map((option) => (
                    <option
                        key={option.id}
                        value={`${option.value}#${option.name}`}
                    >
                        {option.name}
                    </option>
                ))}
            </select>
            {error && <p className="text-sm text-red-500">{error}</p>}
        </div>
    );
};
