import React from "react";
import { cn } from "@/lib/utils";

const FormInput = React.forwardRef(
    (
        {
            className,
            id,
            name,
            type = "text",
            label,
            value,
            defaultValue,
            onChange,
            error,
            placeholder,
            required = false,
            disabled = false,
            ...props
        },
        ref
    ) => {
        return (
            <div className="space-y-2">
                {label && (
                    <label
                        htmlFor={id}
                        className="block text-sm font-medium text-gray-700 dark:text-gray-300"
                    >
                        {label}
                        {required && (
                            <span className="text-red-500 ml-1">*</span>
                        )}
                    </label>
                )}

                <input
                    ref={ref}
                    id={id}
                    name={name}
                    type={type}
                    value={value}
                    defaultValue={defaultValue}
                    onChange={onChange}
                    placeholder={placeholder}
                    disabled={disabled}
                    required={required}
                    className={cn(
                        "w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500",
                        "dark:border-gray-600 dark:bg-gray-800 dark:text-white dark:placeholder-gray-400",
                        "disabled:cursor-not-allowed disabled:bg-gray-100 disabled:text-gray-500 dark:disabled:bg-gray-700 dark:disabled:text-gray-400",
                        error &&
                            "border-red-500 focus:border-red-500 focus:ring-red-500",
                        className
                    )}
                    {...props}
                />

                {error && (
                    <p className="mt-1 text-sm text-red-600 dark:text-red-400">
                        {error}
                    </p>
                )}
            </div>
        );
    }
);

FormInput.displayName = "FormInput";

export { FormInput };
