import { Textarea } from "@/Components/ui/Textarea";
import { Label } from "@/Components/ui/Label";
export const FormTextarea = ({
    id,
    label,
    value,
    setData,
    name,
    error,
    className = "w-full h-32 text-xs",
    placeholder,
    required = false,
}) => {
    return (
        <div>
            <Label htmlFor={id}>{label}</Label>
            <Textarea
                id={id}
                value={value}
                onChange={(e) => setData(name, e.target.value)}
                className={className}
                placeholder={placeholder}
                required={required}
            />
            {error && <p className="text-sm text-red-500">{error}</p>}
        </div>
    );
};
