import React from "react";
import { cn } from "@/lib/utils";
import { RefreshCw } from "lucide-react";

const LoadingIndicator = ({
    className,
    size = "default",
    color = "blue",
    text = "Loading...",
    showText = true,
    ...props
}) => {
    const sizeClasses = {
        sm: "h-4 w-4",
        default: "h-6 w-6",
        lg: "h-8 w-8",
        xl: "h-12 w-12",
    };

    const colorClasses = {
        blue: "text-blue-600 dark:text-blue-400",
        gray: "text-gray-600 dark:text-gray-400",
        green: "text-green-600 dark:text-green-400",
        red: "text-red-600 dark:text-red-400",
        yellow: "text-yellow-600 dark:text-yellow-400",
        purple: "text-purple-600 dark:text-purple-400",
        white: "text-white",
    };

    return (
        <div
            className={cn("flex items-center justify-center", className)}
            role="status"
            aria-live="polite"
            {...props}
        >
            <RefreshCw
                className={cn(
                    "animate-spin",
                    sizeClasses[size],
                    colorClasses[color]
                )}
            />
            {showText && text && (
                <span
                    className={cn(
                        "ml-2 text-sm font-medium",
                        colorClasses[color]
                    )}
                >
                    {text}
                </span>
            )}
            <span className="sr-only">Loading</span>
        </div>
    );
};

// Variant with overlay for full page/section loading
LoadingIndicator.Overlay = ({
    className,
    spinnerSize = "lg",
    color = "blue",
    text = "Loading...",
    ...props
}) => {
    return (
        <div
            className={cn(
                "absolute inset-0 flex items-center justify-center bg-white/80 dark:bg-gray-900/80 z-50",
                className
            )}
            {...props}
        >
            <LoadingIndicator
                size={spinnerSize}
                color={color}
                text={text}
                className="p-4 bg-white dark:bg-gray-800 rounded-lg shadow-lg"
            />
        </div>
    );
};

// Inline variant for use in buttons or small containers
LoadingIndicator.Inline = ({ className, color = "blue", ...props }) => {
    return (
        <RefreshCw
            className={cn(
                "animate-spin h-4 w-4",
                colorClasses[color],
                className
            )}
            {...props}
        />
    );
};

export default LoadingIndicator;
