import ApplicationLogo from "@/Components/ApplicationLogo";
import { Link } from "@inertiajs/react";
import { ThemeProvider, useTheme } from "@/Contexts/ThemeContext";
import { Sun, Moon, Home, FileText } from "lucide-react";

export default function GuestLayout({ children }) {
    return (
        <ThemeProvider>
            <GuestLayoutContent>{children}</GuestLayoutContent>
        </ThemeProvider>
    );
}

// Separate component to use the theme context
function GuestLayoutContent({ children }) {
    const { darkMode, toggleDarkMode } = useTheme();

    return (
        <div className="min-h-screen bg-gradient-to-b from-blue-100 to-white dark:bg-none dark:bg-gray-900 transition-colors duration-200">
            {/* Navigation Header */}
            <nav className="bg-gradient-to-r from-blue-100 to-cyan-100 dark:bg-none border-b border-gray-300 dark:border-gray-600 sticky top-0 z-50">
                <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    <div className="flex justify-between items-center h-16">
                        {/* Logo */}
                        <div className="flex items-center">
                            <Link href="/" className="flex items-center">
                                <h1 className="text-xl font-bold text-blue-800 hover:text-blue-600 dark:text-blue-400 dark:hover:text-blue-300 transition-colors">
                                    AcademicScribe
                                </h1>
                            </Link>
                        </div>

                        {/* Navigation Links */}
                        <div className="hidden md:flex items-center space-x-8">
                            <Link
                                href="/"
                                className="flex items-center text-gray-700 dark:text-gray-300 hover:text-blue-600 dark:hover:text-blue-400 transition-colors"
                            >
                                <Home className="w-4 h-4 mr-2" />
                                Home
                            </Link>
                            <Link
                                href="/place-order"
                                className="flex items-center text-gray-700 dark:text-gray-300 hover:text-blue-600 dark:hover:text-blue-400 transition-colors"
                            >
                                <FileText className="w-4 h-4 mr-2" />
                                Place Order
                            </Link>
                        </div>

                        {/* Right side - Dark mode toggle and mobile menu */}
                        <div className="flex items-center space-x-4">
                            {/* Dark Mode Toggle */}
                            <button
                                onClick={toggleDarkMode}
                                className="p-2 rounded-full text-gray-500 dark:text-gray-400 hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors"
                                aria-label="Toggle dark mode"
                            >
                                {darkMode ? (
                                    <Sun className="h-5 w-5" />
                                ) : (
                                    <Moon className="h-5 w-5" />
                                )}
                            </button>

                            {/* Mobile menu button */}
                            <div className="md:hidden">
                                <button
                                    type="button"
                                    className="p-2 rounded-md text-gray-500 dark:text-gray-400 hover:text-gray-700 dark:hover:text-gray-300 hover:bg-gray-200 dark:hover:bg-gray-700 transition-colors"
                                    aria-label="Open mobile menu"
                                >
                                    <svg className="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 6h16M4 12h16M4 18h16" />
                                    </svg>
                                </button>
                            </div>
                        </div>
                    </div>

                    {/* Mobile Navigation */}
                    <div className="md:hidden">
                        <div className="px-2 pt-2 pb-3 space-y-1">
                            <Link
                                href="/"
                                className="flex items-center px-3 py-2 rounded-md text-gray-700 dark:text-gray-300 hover:text-blue-600 dark:hover:text-blue-400 hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors"
                            >
                                <Home className="w-4 h-4 mr-2" />
                                Home
                            </Link>
                            <Link
                                href="/place-order"
                                className="flex items-center px-3 py-2 rounded-md text-gray-700 dark:text-gray-300 hover:text-blue-600 dark:hover:text-blue-400 hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors"
                            >
                                <FileText className="w-4 h-4 mr-2" />
                                Place Order
                            </Link>
                        </div>
                    </div>
                </div>
            </nav>

            {/* Main Content */}
            <div className="flex min-h-[calc(100vh-4rem)] flex-col items-center justify-center px-4 sm:px-6 lg:px-8 py-12">
                <div className="w-full max-w-md">
                    {children}
                </div>
            </div>
        </div>
    );
}
