import { useEffect } from "react";
import NavBar from "@/Components/NavBar";
import Footer from "@/Components/Footer";
import StructuredData from "@/Components/StructuredData";
import ExitIntentPopup from "@/Components/ExitIntentPopup";
import { ThemeProvider } from "@/Contexts/ThemeContext";
import { Toaster } from "react-hot-toast";
import { preloadCriticalImages } from "@/utils/preloadImages";

export default function MainLayout({ children, pageData = {} }) {
    useEffect(() => {
        const timer = setTimeout(() => {
            preloadCriticalImages();
        }, 100);

        if (process.env.NODE_ENV === "development") {
            import("@/utils/imageUtils").then(({ supportsWebP }) => {
                supportsWebP().then((supported) => {
                    console.log(
                        "WebP support:",
                        supported ? "✅ Supported" : "❌ Not supported"
                    );
                });
            });
        }

        return () => clearTimeout(timer);
    }, []);

    return (
        <ThemeProvider>
            {/* Only render StructuredData if we have pageData with content */}
            {pageData && Object.keys(pageData).length > 0 && (
                <StructuredData pageData={pageData} />
            )}

            <div className="flex flex-col min-h-screen bg-gray-50 dark:bg-gray-900 overflow-x-hidden">
                <NavBar />
                <main className="flex-1 pt-16 overflow-x-hidden">{children}</main>
                <Footer />
            </div>

            {/* Exit Intent Popup - Deactivated */}
            {/* <ExitIntentPopup /> */}

            <Toaster
                position="top-right"
                toastOptions={{
                    duration: 4000,
                    style: {
                        background: "#363636",
                        color: "#fff",
                        fontSize: "14px",
                        borderRadius: "8px",
                        padding: "12px 16px",
                    },
                    success: {
                        style: {
                            background: "#10B981",
                        },
                        iconTheme: {
                            primary: "#fff",
                            secondary: "#10B981",
                        },
                    },
                    error: {
                        style: {
                            background: "#EF4444",
                        },
                        iconTheme: {
                            primary: "#fff",
                            secondary: "#EF4444",
                        },
                    },
                }}
            />
        </ThemeProvider>
    );
}
