export const ensureString = (value, fallback = '') => {
    if (typeof value === 'string') {
        return value;
    }

    if (value === null || value === undefined) {
        return fallback;
    }

    if (typeof value === 'number' || typeof value === 'boolean') {
        return String(value);
    }

    return fallback;
};

export const ensureBoolean = (value, fallback = true) => {
    if (typeof value === 'boolean') {
        return value;
    }

    if (value === null || value === undefined) {
        return fallback;
    }

    if (typeof value === 'number') {
        return value !== 0;
    }

    if (typeof value === 'string') {
        const lowered = value.trim().toLowerCase();
        if (['false', '0', 'no', 'off'].includes(lowered)) {
            return false;
        }
        if (['true', '1', 'yes', 'on'].includes(lowered)) {
            return true;
        }
    }

    return fallback;
};

export const ensureRichText = (value) => {
    if (Array.isArray(value)) {
        return value
            .map((item) => (typeof item === 'string' ? item : ''))
            .filter(Boolean)
            .map((item) => `<p>${item}</p>`)
            .join('');
    }

    if (typeof value === 'object' && value !== null) {
        if ('html' in value) {
            return ensureString(value.html);
        }
        if ('text' in value) {
            return ensureString(value.text);
        }
    }

    return ensureString(value);
};










