import AdminLayout from "@/Layouts/AdminLayout";
import { Link, router, usePage } from "@inertiajs/react";
import {
    Pencil,
    Trash2,
    Ban,
    Check,
    SquareSquare,
    Settings,
    BadgeCheck,
    Receipt,
    CheckCheck,
    Clock,
} from "lucide-react";
import { useEffect, useState } from "react";

export default function Show({ setting }) {
    const { flash } = usePage().props;
    const [flashMsg, setFlashMsg] = useState(flash.message);

    useEffect(() => {
        if (flashMsg) {
            const timer = setTimeout(() => {
                setFlashMsg("");
            }, 3000);
            return () => clearTimeout(timer);
        }
    }, [flashMsg]);

    useEffect(() => {
        setFlashMsg(flash.message);
    }, [flash.message]);

    return (
        <AdminLayout>
            <div className="max-w-4xl mx-auto ">
                <div className="bg-gradient-to-r from-orange-200 to-cyan-200 dark:bg-none dark:bg-gray-800 rounded-lg shadow-md overflow-hidden">
                    {/* Header */}
                    <div className="px-6 py-4 border-b dark:border-gray-700 flex justify-between items-center bg-gradient-to-r from-blue-900 to-cyan-500 dark:bg-none text-gray-100  dark:bg-slate-700 rounded-t-lg">
                        <h1 className="text-2xl font-bold text-gray-100 dark:text-white flex items-center">
                            <Settings className="mr-2 h-6 w-6 text-blue-500" />{" "}
                            {/* {user.name} */}
                            Settings
                        </h1>
                    </div>
                    {flashMsg && (
                        <div className="bg-green-500 text-white text-sm px-4 py-2 rounded-md m-4">
                            {flashMsg}
                        </div>
                    )}

                    {/* Content */}
                    <div className="p-6 space-y-6">
                        <div className="grid grid-cols-1 sm:grid-cols-2 gap-6">
                            <div className="flex items-center gap-3">
                                <Receipt className="h-5 w-5 text-blue-500" />
                                <div>
                                    <span className="text-sm text-gray-600 dark:text-gray-400">
                                        Writer Fee ({setting.writer_fee}% of Net
                                        Amount)
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {setting.writer_fee}
                                    </p>
                                </div>
                            </div>
                            <div className="flex items-center gap-3">
                                <Receipt className="h-5 w-5 text-blue-500" />
                                <div>
                                    <span className="text-sm text-gray-600 dark:text-gray-400">
                                        Writer Deadline (
                                        {setting.writer_deadline}% of Client
                                        Deadline)
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {setting.writer_deadline}
                                    </p>
                                </div>
                            </div>
                            <div className="flex items-center gap-3">
                                <BadgeCheck className="h-5 w-5 text-blue-500" />
                                <div>
                                    <span className="text-sm text-gray-600 dark:text-gray-400">
                                        Coupon Enabled
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {setting.enable_coupon ? "Yes" : "No"}
                                    </p>
                                </div>
                            </div>
                            <div className="flex items-center gap-3">
                                <Receipt className="h-5 w-5 text-blue-500" />
                                <div>
                                    <span className="text-sm text-gray-600 dark:text-gray-400">
                                        Price Per Slide
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {setting.price_per_slide}
                                    </p>
                                </div>
                            </div>
                            <div className="flex items-center gap-3">
                                <SquareSquare className="h-5 w-5 text-blue-500" />
                                <div>
                                    <span className="text-sm text-gray-600 dark:text-gray-400">
                                        Striped Enabled
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {setting.enable_stripe_payment
                                            ? "Yes"
                                            : "No"}
                                    </p>
                                </div>
                            </div>
                            <div className="flex items-center gap-3">
                                <Clock className="h-5 w-5 text-blue-500" />
                                <div>
                                    <span className="text-sm text-gray-600 dark:text-gray-400">
                                        Question Test Duration (minutes)
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {setting.questions_test_duration}
                                    </p>
                                </div>
                            </div>

                            <div className="flex items-center gap-3">
                                <Clock className="h-5 w-5 text-blue-500" />
                                <div>
                                    <span className="text-sm text-gray-600 dark:text-gray-400">
                                        Essay Test Duration (minutes)
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {setting.essay_test_duration}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    {/* Actions */}

                    <div className="px-6 py-4 bg-gradient-to-b from-blue-100 to-white dark:bg-none dark:bg-gray-700 flex flex-wrap gap-3 justify-end">
                        {setting.enable_coupon ? (
                            // Disable Coupon Button
                            <button
                                onClick={() => {
                                    if (
                                        confirm(
                                            "Are you sure you want to deactivate the coupon?"
                                        )
                                    ) {
                                        router.patch(
                                            route(
                                                "admin.settings.deactivate-coupon",
                                                setting.id
                                            )
                                        );
                                    }
                                }}
                                className="flex items-center gap-2 px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-md transition-colors"
                            >
                                <Ban className="h-5 w-5" /> Disable Coupon
                            </button>
                        ) : (
                            // Enable Coupon Button
                            <button
                                onClick={() => {
                                    if (
                                        confirm(
                                            "Are you sure you want to activate the coupon?"
                                        )
                                    ) {
                                        router.patch(
                                            route(
                                                "admin.settings.activate-coupon",
                                                setting.id
                                            )
                                        );
                                    }
                                }}
                                className="flex items-center gap-2 px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-md transition-colors"
                            >
                                <Check className="h-5 w-5" /> Enable Coupon
                            </button>
                        )}

                        {/* Delete Button */}
                        <div>
                            {setting.enable_stripe_payment ? (
                                // Disable Coupon Button
                                <button
                                    onClick={() => {
                                        if (
                                            confirm(
                                                "Are you sure you want to deactivate stripe payment?"
                                            )
                                        ) {
                                            router.patch(
                                                route(
                                                    "admin.settings.deactivate-stripe",
                                                    setting.id
                                                )
                                            );
                                        }
                                    }}
                                    className="flex items-center gap-2 px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-md transition-colors"
                                >
                                    <Ban className="h-5 w-5" /> Disable Stripe
                                </button>
                            ) : (
                                // Enable Coupon Button
                                <button
                                    onClick={() => {
                                        if (
                                            confirm(
                                                "Are you sure you want to activate Stripe Payment?"
                                            )
                                        ) {
                                            router.patch(
                                                route(
                                                    "admin.settings.activate-stripe",
                                                    setting.id
                                                )
                                            );
                                        }
                                    }}
                                    className="flex items-center gap-2 px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-md transition-colors"
                                >
                                    <CheckCheck className="h-5 w-5" /> Enable
                                    Stripe
                                </button>
                            )}
                        </div>

                        {/* Edit Button */}
                        <Link
                            href={route("admin.settings.edit", setting.id)}
                            className="flex items-center gap-2 px-4 py-2 bg-amber-600 hover:bg-amber-700 text-white rounded-md transition-colors"
                        >
                            <Pencil className="h-5 w-5" /> Edit
                        </Link>
                    </div>
                </div>
            </div>
        </AdminLayout>
    );
}
