import { NormalSelect } from "@/Components/ui/NormalSelect";
import AdminLayout from "@/Layouts/AdminLayout";
import { useForm, Link } from "@inertiajs/react";

export default function Edit({ pricing }) {
    const { data, setData, patch, processing, errors } = useForm({
        value: pricing.value,
        urgency: pricing.urgency,
        duration: pricing.duration,
    });
    console.log(pricing);

    const handleSubmit = (e) => {
        e.preventDefault();
        patch(route("pricings.update", pricing.id));
    };

    return (
        <AdminLayout>
            <div className="max-w-2xl mx-auto">
                <div className="bg-gradient-to-r from-orange-200 to-cyan-200 dark:bg-none dark:bg-gray-800 rounded-lg shadow-lg">
                    <div className="px-6 py-4 border-b dark:border-gray-700 bg-gradient-to-r from-blue-900 to-cyan-500 dark:bg-none dark:bg-slate-700 rounded-t-lg">
                        <h1 className="text-md lg:text-xl font-bold text-gray-100 dark:text-white">
                            Edit Urgency & Pricing
                        </h1>
                    </div>

                    <form onSubmit={handleSubmit} className="p-6 space-y-6">
                        <div>
                            <label className="block text-sm font-medium text-gray-700 dark:text-gray-300">
                                Urgency
                            </label>
                            <input
                                type="text"
                                value={data.urgency}
                                onChange={(e) =>
                                    setData("urgency", e.target.value)
                                }
                                className="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500"
                            />
                            {errors.urgency && (
                                <div className="mt-1 text-red-600">
                                    {errors.urgency}
                                </div>
                            )}
                        </div>

                        <div>
                            <label className="block text-sm font-medium text-gray-700 dark:text-gray-300">
                                Pricing Value (in USD)
                            </label>
                            <input
                                type="number"
                                step="0.01"
                                value={data.value}
                                onChange={(e) =>
                                    setData("value", e.target.value)
                                }
                                className="mt-1 block w-full rounded-md border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-blue-500 focus:ring-blue-500"
                            />
                            {errors.value && (
                                <div className="mt-1 text-red-600">
                                    {errors.value}
                                </div>
                            )}
                        </div>

                        <div>
                            <NormalSelect
                                id="duration"
                                name="duration"
                                label="Duration"
                                value={data.duration}
                                setData={setData}
                                options={[
                                    {
                                        id: 1,
                                        value: "1",
                                        name: "Hours",
                                    },
                                    {
                                        id: 2,
                                        value: "2",
                                        name: "Days",
                                    },
                                ]}
                                error={errors.duration}
                                placeholder="Select Duration"
                                className="dark:text-gray-200"
                            />
                        </div>

                        <div className="flex justify-end gap-3">
                            <Link
                                href={route("pricings.index")}
                                className="px-4 py-2 bg-gray-500 text-white rounded-md hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2"
                            >
                                Cancel
                            </Link>
                            <button
                                type="submit"
                                disabled={processing}
                                className="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 disabled:opacity-50"
                            >
                                Update
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </AdminLayout>
    );
}
