import AdminLayout from "@/Layouts/AdminLayout";
import { Link, router, usePage } from "@inertiajs/react";
import {
    Pencil,
    Trash2,
    Ban,
    Check,
    Mail,
    User,
    Shield,
    MoveLeft,
} from "lucide-react";
import { useEffect, useState } from "react";

export default function Show({ user }) {
    const { flash } = usePage().props;
    const [flashMsg, setFlashMsg] = useState(flash.message);

    useEffect(() => {
        if (flashMsg) {
            const timer = setTimeout(() => {
                setFlashMsg("");
            }, 3000);
            return () => clearTimeout(timer);
        }
    }, [flashMsg]);

    useEffect(() => {
        setFlashMsg(flash.message);
    }, [flash.message]);

    const handleDelete = (userId) => {
        if (confirm("Are you sure you want to delete this user?")) {
            router.delete(route("admin.users.destroy", userId));
        }
    };

    return (
        <AdminLayout>
            <div className="max-w-4xl mx-auto ">
                <div className=" flex justify-end items-center mb-6 ">
                    <Link
                        href="/admin/users"
                        className="flex items-center px-3 py-1.5 sm:px-4 sm:py-2 text-indigo-600 dark:text-gray-100 bg-indigo-50 dark:bg-indigo-900 hover:bg-indigo-100 dark:hover:bg-indigo-800 rounded-full shadow-sm border border-indigo-200 dark:border-indigo-700 transition-colors duration-200 text-sm"
                    >
                        <MoveLeft className="mr-1 h-3 w-3 sm:h-4 sm:w-4" />
                        All Users
                    </Link>
                </div>
                <div className="bg-gradient-to-r from-orange-200 to-cyan-200 dark:bg-none dark:bg-gray-800 rounded-lg shadow-md overflow-hidden">
                    {/* Header */}

                    <div className="px-6 py-4 border-b dark:border-gray-700 flex justify-between items-center bg-gradient-to-r from-blue-900 to-cyan-500 rounded-md shadow-md">
                        <h1 className="text-2xl font-bold text-gray-100 dark:text-white flex items-center ">
                            <User className="mr-2 h-6 w-6 text-blue-100" />{" "}
                            {user.name}
                        </h1>
                    </div>
                    {flashMsg && (
                        <div className="bg-green-500 text-white text-sm px-4 py-2 rounded-md m-4">
                            {flashMsg}
                        </div>
                    )}

                    {/* Content */}
                    <div className="p-6 space-y-6">
                        <div className="grid grid-cols-1 sm:grid-cols-2 gap-6">
                            <div className="flex items-center gap-3">
                                <Mail className="h-5 w-5 text-blue-500" />
                                <div>
                                    <span className="text-sm text-gray-600 dark:text-gray-400">
                                        Email
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {user.email}
                                    </p>
                                </div>
                            </div>

                            <div className="flex items-center gap-3">
                                <Shield className="h-5 w-5 text-blue-500" />
                                <div>
                                    <span className="text-sm text-gray-600 dark:text-gray-400">
                                        User Type
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {user.user_type}
                                    </p>
                                </div>
                            </div>

                            <div className="flex items-center gap-3">
                                <Ban className="h-5 w-5 text-blue-500" />
                                <div>
                                    <span className="text-sm text-gray-600 dark:text-gray-400">
                                        Status
                                    </span>
                                    <p className="text-lg font-medium text-gray-900 dark:text-white">
                                        {user.status}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    {/* Actions */}
                    <div className=" px-6 py-4 bg-gradient-to-t from-orange-200 to-cyan-200 dark:bg-none dark:bg-gray-700 flex flex-wrap gap-3 justify-end">
                        {user.status === "inactive" ? (
                            <button
                                onClick={() => {
                                    if (
                                        confirm(
                                            "Are you sure you want to activate this user?"
                                        )
                                    ) {
                                        router.patch(
                                            route(
                                                "admin.users.activate",
                                                user.id
                                            )
                                        );
                                    }
                                }}
                                className="flex items-center gap-2 px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-md transition-colors"
                            >
                                <Check className="h-5 w-5" /> Activate
                            </button>
                        ) : (
                            <button
                                onClick={() => {
                                    if (
                                        confirm(
                                            "Are you sure you want to deactivate this user?"
                                        )
                                    ) {
                                        router.patch(
                                            route(
                                                "admin.users.deactivate",
                                                user.id
                                            )
                                        );
                                    }
                                }}
                                className="flex items-center gap-2 px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-md transition-colors"
                            >
                                <Ban className="h-5 w-5" /> Deactivate
                            </button>
                        )}

                        <Link
                            href={route("admin.users.edit", user.id)}
                            className="flex items-center gap-2 px-4 py-2 bg-amber-600 hover:bg-amber-700 text-white rounded-md transition-colors"
                        >
                            <Pencil className="h-5 w-5" /> Edit
                        </Link>

                        <button
                            onClick={() => handleDelete(user.id)}
                            className="flex items-center gap-2 px-4 py-2 bg-red-600 hover:bg-red-700 text-white rounded-md transition-colors"
                        >
                            <Trash2 className="h-5 w-5" /> Delete
                        </button>
                    </div>
                </div>
            </div>
        </AdminLayout>
    );
}
