import { Head, Link } from '@inertiajs/react';
import AdminLayout from '@/Layouts/AdminLayout';
import { 
    ArrowLeft,
    BarChart3,
    AlertTriangle,
    CheckCircle,
    Clock,
    TrendingUp
} from 'lucide-react';

export default function WriterInfractionsStatistics({ 
    totalInfractions,
    activeInfractions,
    resolvedInfractions,
    escalatedInfractions,
    infractionsByType,
    infractionsBySeverity,
    infractionsByStatus,
    monthlyInfractions
}) {
    return (
        <AdminLayout>
            <Head title="Writer Infractions Statistics" />
            
            <div className="py-6">
                <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                    {/* Header */}
                    <div className="mb-8">
                        <div className="flex items-center gap-4 mb-4">
                            <Link
                                href={route('admin.writer-infractions.index')}
                                className="inline-flex items-center text-gray-600 hover:text-gray-900 dark:text-gray-400 dark:hover:text-white"
                            >
                                <ArrowLeft size={16} className="mr-2" />
                                Back to Infractions
                            </Link>
                        </div>
                        <h1 className="text-3xl font-bold text-gray-900 dark:text-white">
                            Writer Infractions Statistics
                        </h1>
                        <p className="mt-2 text-gray-600 dark:text-gray-400">
                            Overview and analytics of writer infractions
                        </p>
                    </div>

                    {/* Summary Cards */}
                    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                        <div className="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                            <div className="flex items-center">
                                <div className="flex-shrink-0">
                                    <AlertTriangle className="h-8 w-8 text-red-600" />
                                </div>
                                <div className="ml-5 w-0 flex-1">
                                    <dl>
                                        <dt className="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">
                                            Total Infractions
                                        </dt>
                                        <dd className="text-lg font-medium text-gray-900 dark:text-white">
                                            {totalInfractions}
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>

                        <div className="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                            <div className="flex items-center">
                                <div className="flex-shrink-0">
                                    <Clock className="h-8 w-8 text-yellow-600" />
                                </div>
                                <div className="ml-5 w-0 flex-1">
                                    <dl>
                                        <dt className="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">
                                            Active Infractions
                                        </dt>
                                        <dd className="text-lg font-medium text-gray-900 dark:text-white">
                                            {activeInfractions}
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>

                        <div className="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                            <div className="flex items-center">
                                <div className="flex-shrink-0">
                                    <CheckCircle className="h-8 w-8 text-green-600" />
                                </div>
                                <div className="ml-5 w-0 flex-1">
                                    <dl>
                                        <dt className="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">
                                            Resolved Infractions
                                        </dt>
                                        <dd className="text-lg font-medium text-gray-900 dark:text-white">
                                            {resolvedInfractions}
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>

                        <div className="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                            <div className="flex items-center">
                                <div className="flex-shrink-0">
                                    <TrendingUp className="h-8 w-8 text-orange-600" />
                                </div>
                                <div className="ml-5 w-0 flex-1">
                                    <dl>
                                        <dt className="text-sm font-medium text-gray-500 dark:text-gray-400 truncate">
                                            Escalated Infractions
                                        </dt>
                                        <dd className="text-lg font-medium text-gray-900 dark:text-white">
                                            {escalatedInfractions}
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>
                    </div>

                    {/* Charts and Data */}
                    <div className="grid grid-cols-1 lg:grid-cols-2 gap-8">
                        {/* Infractions by Type */}
                        <div className="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                            <h3 className="text-lg font-medium text-gray-900 dark:text-white mb-4">
                                Infractions by Type
                            </h3>
                            <div className="space-y-3">
                                {infractionsByType.map((item) => (
                                    <div key={item.infraction_type} className="flex items-center justify-between">
                                        <span className="text-sm text-gray-700 dark:text-gray-300">
                                            {item.infraction_type.replace('_', ' ').replace(/\b\w/g, l => l.toUpperCase())}
                                        </span>
                                        <span className="text-sm font-medium text-gray-900 dark:text-white">
                                            {item.count}
                                        </span>
                                    </div>
                                ))}
                            </div>
                        </div>

                        {/* Infractions by Severity */}
                        <div className="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                            <h3 className="text-lg font-medium text-gray-900 dark:text-white mb-4">
                                Infractions by Severity
                            </h3>
                            <div className="space-y-3">
                                {infractionsBySeverity.map((item) => (
                                    <div key={item.severity_level} className="flex items-center justify-between">
                                        <span className="text-sm text-gray-700 dark:text-gray-300">
                                            {item.severity_level.charAt(0).toUpperCase() + item.severity_level.slice(1)}
                                        </span>
                                        <span className="text-sm font-medium text-gray-900 dark:text-white">
                                            {item.count}
                                        </span>
                                    </div>
                                ))}
                            </div>
                        </div>

                        {/* Infractions by Status */}
                        <div className="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                            <h3 className="text-lg font-medium text-gray-900 dark:text-white mb-4">
                                Infractions by Status
                            </h3>
                            <div className="space-y-3">
                                {infractionsByStatus.map((item) => (
                                    <div key={item.status} className="flex items-center justify-between">
                                        <span className="text-sm text-gray-700 dark:text-gray-300">
                                            {item.status.replace('_', ' ').replace(/\b\w/g, l => l.toUpperCase())}
                                        </span>
                                        <span className="text-sm font-medium text-gray-900 dark:text-white">
                                            {item.count}
                                        </span>
                                    </div>
                                ))}
                            </div>
                        </div>

                        {/* Monthly Trend */}
                        <div className="bg-white dark:bg-gray-800 rounded-lg shadow-md p-6">
                            <h3 className="text-lg font-medium text-gray-900 dark:text-white mb-4">
                                Monthly Trend (Last 12 Months)
                            </h3>
                            <div className="space-y-3">
                                {monthlyInfractions.map((item) => (
                                    <div key={item.month} className="flex items-center justify-between">
                                        <span className="text-sm text-gray-700 dark:text-gray-300">
                                            {item.month}
                                        </span>
                                        <span className="text-sm font-medium text-gray-900 dark:text-white">
                                            {item.count}
                                        </span>
                                    </div>
                                ))}
                            </div>
                        </div>
                    </div>

                    {/* No Data Message */}
                    {totalInfractions === 0 && (
                        <div className="text-center py-12">
                            <BarChart3 size={48} className="mx-auto text-gray-400 mb-4" />
                            <h3 className="text-lg font-medium text-gray-900 dark:text-white mb-2">
                                No Statistics Available
                            </h3>
                            <p className="text-gray-600 dark:text-gray-400 mb-6">
                                No writer infractions have been reported yet, so there are no statistics to display.
                            </p>
                            <Link
                                href={route('admin.writer-infractions.create')}
                                className="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500"
                            >
                                Report First Infraction
                            </Link>
                        </div>
                    )}
                </div>
            </div>
        </AdminLayout>
    );
} 