import React from 'react';
import { Head } from '@inertiajs/react';
import Layout from '@/Layouts/MainLayout';
import ContentBlockRenderer from '@/Components/CMS/ContentBlockRenderer';

export default function DynamicPage({ page, contentBlocks, pageData, openGraph, twitterCard, seoData }) {
    // Generate structured data script
    const structuredDataScript = pageData.structuredData ? (
        <script
            type="application/ld+json"
            dangerouslySetInnerHTML={{
                __html: JSON.stringify(pageData.structuredData)
            }}
        />
    ) : null;

    return (
        <Layout>
            <Head>
                <title>{pageData.title}</title>
                <meta name="description" content={pageData.description} />
                {pageData.keywords && <meta name="keywords" content={pageData.keywords} />}
                <link rel="canonical" href={pageData.canonicalUrl} />
                
                {/* Open Graph */}
                <meta property="og:title" content={openGraph['og:title']} />
                <meta property="og:description" content={openGraph['og:description']} />
                <meta property="og:image" content={openGraph['og:image']} />
                <meta property="og:type" content={openGraph['og:type']} />
                <meta property="og:url" content={openGraph['og:url']} />
                <meta property="og:site_name" content={openGraph['og:site_name']} />
                <meta property="og:locale" content={openGraph['og:locale']} />
                
                {/* Twitter Card */}
                <meta name="twitter:card" content={twitterCard['twitter:card']} />
                <meta name="twitter:site" content={twitterCard['twitter:site']} />
                <meta name="twitter:creator" content={twitterCard['twitter:creator']} />
                <meta name="twitter:title" content={twitterCard['twitter:title']} />
                <meta name="twitter:description" content={twitterCard['twitter:description']} />
                <meta name="twitter:image" content={twitterCard['twitter:image']} />
                {twitterCard['twitter:image:alt'] && (
                    <meta name="twitter:image:alt" content={twitterCard['twitter:image:alt']} />
                )}
                
                {/* Structured Data */}
                {structuredDataScript}
            </Head>

            <main>
                <ContentBlockRenderer blocks={contentBlocks} />
            </main>
        </Layout>
    );
}
