import { useState } from "react";
import { usePage } from "@inertiajs/react";
import MainLayout from "@/Layouts/MainLayout";
import ContentBlockRenderer from "@/Components/CMS/ContentBlockRenderer";

export default function Home({
    contentBlocks,
    pageData,
    isCMS = true,
}) {
    // Trust the database data completely - no fallbacks
    // All SEO data comes from database via controller

    // Early return if CMS data is not available
    if (!isCMS || !contentBlocks || contentBlocks.length === 0) {
        return (
            <MainLayout pageData={pageData}>
                <main role="main" aria-label="Main content" id="main-content">
                    <div className="min-h-screen flex items-center justify-center">
                        <div className="text-center">
                            <h1 className="text-2xl font-bold text-gray-900 dark:text-white mb-4">
                                Page Not Available
                            </h1>
                            <p className="text-gray-600 dark:text-gray-300">
                                The homepage content is currently being updated. Please try again later.
                            </p>
                        </div>
                    </div>
                </main>
            </MainLayout>
        );
    }

    return (
        <MainLayout pageData={pageData}>
            <main role="main" aria-label="Main content" id="main-content">
                {/* Render CMS content blocks - price calculator will be included if added to CMS */}
                <ContentBlockRenderer blocks={contentBlocks} />
            </main>
        </MainLayout>
    );
}
