import React from "react";
import { Head } from "@inertiajs/react";
import MainLayout from "@/Layouts/MainLayout";

export default function PrivacyPolicy({ lastUpdated }) {
    return (
        <MainLayout>
            <Head>
                <title>Privacy Policy | Academic Scribe</title>
                <meta
                    name="description"
                    content="Privacy Policy for Academic Scribe academic writing service. Learn how we collect, use, and protect your personal information."
                />
                <meta name="robots" content="index, follow" />
                <link rel="canonical" href={route("privacy-policy")} />
            </Head>

            <div className="min-h-screen bg-gray-50 py-12">
                <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                    {/* Header */}
                    <div className="bg-white rounded-lg shadow-sm p-8 mb-8">
                        <h1 className="text-4xl font-bold text-gray-900 mb-4">
                            Privacy Policy
                        </h1>
                        <p className="text-gray-600 text-lg">
                            Last updated: {lastUpdated || "January 1, 2024"}
                        </p>
                        <p className="text-gray-600 mt-4">
                            At Academic Scribe, we are committed to protecting
                            your privacy and ensuring the security of your
                            personal information. This Privacy Policy explains
                            how we collect, use, and safeguard your data.
                        </p>
                    </div>

                    {/* Content */}
                    <div className="bg-white rounded-lg shadow-sm p-8 space-y-8">
                        {/* Information We Collect */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                1. Information We Collect
                            </h2>

                            <div className="space-y-4">
                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Personal Information
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            Name and contact information (email,
                                            phone number)
                                        </li>
                                        <li>
                                            Account credentials (username,
                                            password)
                                        </li>
                                        <li>
                                            Payment information (processed
                                            securely through third-party
                                            providers)
                                        </li>
                                        <li>
                                            Academic information (institution,
                                            level of study)
                                        </li>
                                    </ul>
                                </div>

                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Order Information
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            Assignment details and requirements
                                        </li>
                                        <li>Uploaded files and documents</li>
                                        <li>
                                            Communication with writers and
                                            support
                                        </li>
                                        <li>Order history and preferences</li>
                                    </ul>
                                </div>

                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Technical Information
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            IP address and browser information
                                        </li>
                                        <li>
                                            Device information and operating
                                            system
                                        </li>
                                        <li>
                                            Website usage data and analytics
                                        </li>
                                        <li>
                                            Cookies and similar tracking
                                            technologies
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </section>

                        {/* How We Use Information */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                2. How We Use Your Information
                            </h2>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    Provide and deliver our academic writing
                                    services
                                </li>
                                <li>
                                    Process payments and manage your account
                                </li>
                                <li>
                                    Communicate with you about orders and
                                    support
                                </li>
                                <li>Match you with appropriate writers</li>
                                <li>
                                    Improve our services and user experience
                                </li>
                                <li>
                                    Send important updates and notifications
                                </li>
                                <li>Comply with legal obligations</li>
                                <li>
                                    Prevent fraud and ensure platform security
                                </li>
                            </ul>
                        </section>

                        {/* Information Sharing */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                3. Information Sharing
                            </h2>

                            <p className="text-gray-600 mb-4">
                                We do not sell, trade, or rent your personal
                                information to third parties. We may share your
                                information only in the following circumstances:
                            </p>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    <strong>With Writers:</strong> Necessary
                                    order details to complete your assignment
                                </li>
                                <li>
                                    <strong>Service Providers:</strong> Payment
                                    processors, hosting services, and analytics
                                    tools
                                </li>
                                <li>
                                    <strong>Legal Requirements:</strong> When
                                    required by law or to protect our rights
                                </li>
                                <li>
                                    <strong>Business Transfers:</strong> In case
                                    of merger, acquisition, or sale of assets
                                </li>
                                <li>
                                    <strong>With Consent:</strong> When you
                                    explicitly agree to share information
                                </li>
                            </ul>
                        </section>

                        {/* Data Security */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                4. Data Security
                            </h2>

                            <p className="text-gray-600 mb-4">
                                We implement industry-standard security measures
                                to protect your information:
                            </p>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    SSL encryption for all data transmission
                                </li>
                                <li>
                                    Secure servers with regular security updates
                                </li>
                                <li>
                                    Access controls and authentication systems
                                </li>
                                <li>Regular security audits and monitoring</li>
                                <li>
                                    Secure payment processing through trusted
                                    providers
                                </li>
                                <li>Data backup and recovery procedures</li>
                            </ul>
                        </section>

                        {/* Your Rights */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                5. Your Rights
                            </h2>

                            <p className="text-gray-600 mb-4">
                                You have the following rights regarding your
                                personal information:
                            </p>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    <strong>Access:</strong> Request a copy of
                                    your personal data
                                </li>
                                <li>
                                    <strong>Correction:</strong> Update or
                                    correct inaccurate information
                                </li>
                                <li>
                                    <strong>Deletion:</strong> Request deletion
                                    of your personal data
                                </li>
                                <li>
                                    <strong>Portability:</strong> Receive your
                                    data in a portable format
                                </li>
                                <li>
                                    <strong>Restriction:</strong> Limit how we
                                    process your information
                                </li>
                                <li>
                                    <strong>Objection:</strong> Object to
                                    certain types of processing
                                </li>
                                <li>
                                    <strong>Withdraw Consent:</strong> Withdraw
                                    consent for data processing
                                </li>
                            </ul>

                            <p className="text-gray-600 mt-4">
                                To exercise these rights, please contact us at{" "}
                                <a
                                    href="mailto:privacy@academicscribe.com"
                                    className="text-blue-600 hover:text-blue-800"
                                >
                                    privacy@academicscribe.com
                                </a>
                            </p>
                        </section>

                        {/* Cookies */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                6. Cookies and Tracking
                            </h2>

                            <p className="text-gray-600 mb-4">
                                We use cookies and similar technologies to
                                enhance your experience:
                            </p>

                            <div className="space-y-3">
                                <div>
                                    <strong className="text-gray-800">
                                        Essential Cookies:
                                    </strong>
                                    <span className="text-gray-600">
                                        {" "}
                                        Required for basic site functionality
                                    </span>
                                </div>
                                <div>
                                    <strong className="text-gray-800">
                                        Analytics Cookies:
                                    </strong>
                                    <span className="text-gray-600">
                                        {" "}
                                        Help us understand site usage and
                                        improve services
                                    </span>
                                </div>
                                <div>
                                    <strong className="text-gray-800">
                                        Preference Cookies:
                                    </strong>
                                    <span className="text-gray-600">
                                        {" "}
                                        Remember your settings and preferences
                                    </span>
                                </div>
                            </div>

                            <p className="text-gray-600 mt-4">
                                You can manage cookie preferences through your
                                browser settings.
                            </p>
                        </section>

                        {/* Data Retention */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                7. Data Retention
                            </h2>

                            <p className="text-gray-600 mb-4">
                                We retain your information for as long as
                                necessary to provide our services:
                            </p>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    Account information: Until account deletion
                                </li>
                                <li>
                                    Order history: 7 years for legal compliance
                                </li>
                                <li>
                                    Payment records: As required by financial
                                    regulations
                                </li>
                                <li>
                                    Communication logs: 3 years for quality
                                    assurance
                                </li>
                                <li>
                                    Analytics data: Aggregated and anonymized
                                    after 2 years
                                </li>
                            </ul>
                        </section>

                        {/* Third-Party Services */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                8. Third-Party Services
                            </h2>

                            <p className="text-gray-600 mb-4">
                                We work with trusted third-party services that
                                have their own privacy policies:
                            </p>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>Payment processors (Stripe, PayPal)</li>
                                <li>Analytics services (Google Analytics)</li>
                                <li>Cloud hosting providers</li>
                                <li>Email service providers</li>
                                <li>Customer support tools</li>
                            </ul>
                        </section>

                        {/* International Transfers */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                9. International Data Transfers
                            </h2>

                            <p className="text-gray-600">
                                Your information may be transferred to and
                                processed in countries other than your own. We
                                ensure appropriate safeguards are in place to
                                protect your data in accordance with applicable
                                privacy laws and regulations.
                            </p>
                        </section>

                        {/* Updates */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                10. Policy Updates
                            </h2>

                            <p className="text-gray-600">
                                We may update this Privacy Policy from time to
                                time. We will notify you of any material changes
                                by posting the new policy on our website and
                                updating the "Last updated" date. Your continued
                                use of our services after changes constitutes
                                acceptance of the updated policy.
                            </p>
                        </section>

                        {/* Contact Information */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                11. Contact Us
                            </h2>

                            <p className="text-gray-600 mb-4">
                                If you have questions about this Privacy Policy
                                or our data practices, please contact us:
                            </p>

                            <div className="bg-gray-50 rounded-lg p-6">
                                <div className="space-y-2 text-gray-600">
                                    <div>
                                        <strong>Email:</strong>{" "}
                                        privacy@supremefreelancers.com
                                    </div>
                                    <div>
                                        <strong>Support:</strong>{" "}
                                        support@supremefreelancers.com
                                    </div>
                                    <div>
                                        <strong>Phone:</strong> +1 (800)
                                        123-4567
                                    </div>
                                    <div>
                                        <strong>Address:</strong> 123 Academic
                                        Street, Education City, EC 12345
                                    </div>
                                </div>
                            </div>
                        </section>
                    </div>

                    {/* Footer Navigation */}
                    <div className="mt-8 text-center">
                        <div className="flex flex-wrap justify-center gap-6 text-sm">
                            <a
                                href="/terms-of-service"
                                className="text-blue-600 hover:text-blue-800"
                            >
                                Terms of Service
                            </a>
                            <a
                                href="/cookie-policy"
                                className="text-blue-600 hover:text-blue-800"
                            >
                                Cookie Policy
                            </a>
                            <a
                                href="/contact"
                                className="text-blue-600 hover:text-blue-800"
                            >
                                Contact Us
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </MainLayout>
    );
}
