import { useForm } from "@inertiajs/react";
import PrimaryButton from "@/Components/PrimaryButton";
import InputLabel from "@/Components/InputLabel";
import { Settings as SettingsIcon } from "lucide-react";

export default function PreferencesSettings({
    clientPreferences,
    academicLevels,
    paperTypes,
    subjects,
    languages,
    onSuccess,
}) {
    const { data, setData, post, processing } = useForm({
        default_academic_level_id: clientPreferences?.default_academic_level_id || "",
        default_paper_type_id: clientPreferences?.default_paper_type_id || "",
        default_subject_id: clientPreferences?.default_subject_id || "",
        default_spacing: clientPreferences?.default_spacing || "double",
        default_citation_style: clientPreferences?.default_citation_style || "",
        default_language_id: clientPreferences?.default_language_id || "",
        default_currency: clientPreferences?.default_currency || "USD",
        default_deadline_buffer_hours: clientPreferences?.default_deadline_buffer_hours || 24,
        theme: clientPreferences?.theme || "auto",
        timezone: clientPreferences?.timezone || "",
        date_format: clientPreferences?.date_format || "Y-m-d",
        time_format: clientPreferences?.time_format || "H:i",
    });

    const handleSubmit = (e) => {
        e.preventDefault();
        post(route("settings.preferences.update"), {
            preserveScroll: true,
            onSuccess: () => {
                onSuccess("Order preferences updated successfully.");
            },
        });
    };

    return (
        <form onSubmit={handleSubmit} className="space-y-6">
            <div className="flex items-center gap-2 mb-4">
                <SettingsIcon className="h-5 w-5 text-gray-500 dark:text-gray-400" />
                <h3 className="text-lg font-semibold text-gray-900 dark:text-white">
                    Default Order Settings
                </h3>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <InputLabel htmlFor="default_academic_level_id" value="Default Academic Level" />
                    <select
                        id="default_academic_level_id"
                        value={data.default_academic_level_id}
                        onChange={(e) => setData("default_academic_level_id", e.target.value)}
                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    >
                        <option value="">None</option>
                        {academicLevels.map((level) => (
                            <option key={level.id} value={level.id}>
                                {level.name}
                            </option>
                        ))}
                    </select>
                </div>

                <div>
                    <InputLabel htmlFor="default_paper_type_id" value="Default Paper Type" />
                    <select
                        id="default_paper_type_id"
                        value={data.default_paper_type_id}
                        onChange={(e) => setData("default_paper_type_id", e.target.value)}
                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    >
                        <option value="">None</option>
                        {paperTypes.map((type) => (
                            <option key={type.id} value={type.id}>
                                {type.name}
                            </option>
                        ))}
                    </select>
                </div>

                <div>
                    <InputLabel htmlFor="default_subject_id" value="Default Subject" />
                    <select
                        id="default_subject_id"
                        value={data.default_subject_id}
                        onChange={(e) => setData("default_subject_id", e.target.value)}
                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    >
                        <option value="">None</option>
                        {subjects.map((subject) => (
                            <option key={subject.id} value={subject.id}>
                                {subject.name}
                            </option>
                        ))}
                    </select>
                </div>

                <div>
                    <InputLabel htmlFor="default_spacing" value="Default Spacing" />
                    <select
                        id="default_spacing"
                        value={data.default_spacing}
                        onChange={(e) => setData("default_spacing", e.target.value)}
                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    >
                        <option value="double">Double Spaced</option>
                        <option value="single">Single Spaced</option>
                        <option value="1.5">1.5 Spaced</option>
                    </select>
                </div>

                <div>
                    <InputLabel htmlFor="default_language_id" value="Default Language" />
                    <select
                        id="default_language_id"
                        value={data.default_language_id}
                        onChange={(e) => setData("default_language_id", e.target.value)}
                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    >
                        <option value="">None</option>
                        {languages.map((language) => (
                            <option key={language.id} value={language.id}>
                                {language.name}
                            </option>
                        ))}
                    </select>
                </div>

                <div>
                    <InputLabel htmlFor="default_currency" value="Default Currency" />
                    <select
                        id="default_currency"
                        value={data.default_currency}
                        onChange={(e) => setData("default_currency", e.target.value)}
                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    >
                        <option value="USD">USD ($)</option>
                        <option value="EUR">EUR (€)</option>
                        <option value="GBP">GBP (£)</option>
                        <option value="CAD">CAD (C$)</option>
                        <option value="AUD">AUD (A$)</option>
                    </select>
                </div>

                <div>
                    <InputLabel htmlFor="default_deadline_buffer_hours" value="Default Deadline Buffer (Hours)" />
                    <input
                        type="number"
                        id="default_deadline_buffer_hours"
                        value={data.default_deadline_buffer_hours}
                        onChange={(e) => setData("default_deadline_buffer_hours", parseInt(e.target.value))}
                        min="0"
                        max="168"
                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    />
                </div>

                <div>
                    <InputLabel htmlFor="theme" value="Theme" />
                    <select
                        id="theme"
                        value={data.theme}
                        onChange={(e) => setData("theme", e.target.value)}
                        className="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                    >
                        <option value="auto">Auto (System)</option>
                        <option value="light">Light</option>
                        <option value="dark">Dark</option>
                    </select>
                </div>
            </div>

            <div className="flex justify-end">
                <PrimaryButton disabled={processing}>
                    {processing ? "Saving..." : "Save Preferences"}
                </PrimaryButton>
            </div>
        </form>
    );
}







