import { useForm } from "@inertiajs/react";
import PrimaryButton from "@/Components/PrimaryButton";
import { Shield } from "lucide-react";

export default function PrivacySettings({ clientPreferences, onSuccess }) {
    const { data, setData, post, processing } = useForm({
        allow_writer_contact_after_completion: clientPreferences?.allow_writer_contact_after_completion ?? true,
        show_order_history_to_writers: clientPreferences?.show_order_history_to_writers ?? false,
        profile_visible_to_writers: clientPreferences?.profile_visible_to_writers ?? true,
        preferred_communication_method: clientPreferences?.preferred_communication_method || "in_app",
        auto_assign_writer: clientPreferences?.auto_assign_writer ?? false,
        auto_send_invoices: clientPreferences?.auto_send_invoices ?? true,
        invoice_format: clientPreferences?.invoice_format || "pdf",
    });

    const handleSubmit = (e) => {
        e.preventDefault();
        post(route("settings.preferences.update"), {
            preserveScroll: true,
            onSuccess: () => {
                onSuccess("Privacy & communication preferences updated successfully.");
            },
        });
    };

    return (
        <form onSubmit={handleSubmit} className="space-y-6">
            <div className="flex items-center gap-2 mb-4">
                <Shield className="h-5 w-5 text-gray-500 dark:text-gray-400" />
                <h3 className="text-lg font-semibold text-gray-900 dark:text-white">
                    Privacy & Communication Preferences
                </h3>
            </div>

            <div className="space-y-6">
                <div className="p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                    <h4 className="text-sm font-semibold text-gray-900 dark:text-white mb-3">
                        Writer Interaction
                    </h4>
                    <div className="space-y-3">
                        <label className="flex items-center justify-between">
                            <div>
                                <span className="text-sm font-medium text-gray-900 dark:text-white">
                                    Allow writers to contact after order completion
                                </span>
                                <p className="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                    Allow writers to send follow-up messages after order completion
                                </p>
                            </div>
                            <input
                                type="checkbox"
                                checked={data.allow_writer_contact_after_completion}
                                onChange={(e) => setData("allow_writer_contact_after_completion", e.target.checked)}
                                className="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500"
                            />
                        </label>

                        <label className="flex items-center justify-between">
                            <div>
                                <span className="text-sm font-medium text-gray-900 dark:text-white">
                                    Show order history to writers
                                </span>
                                <p className="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                    Allow writers to see your previous order history
                                </p>
                            </div>
                            <input
                                type="checkbox"
                                checked={data.show_order_history_to_writers}
                                onChange={(e) => setData("show_order_history_to_writers", e.target.checked)}
                                className="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500"
                            />
                        </label>

                        <label className="flex items-center justify-between">
                            <div>
                                <span className="text-sm font-medium text-gray-900 dark:text-white">
                                    Profile visible to writers
                                </span>
                                <p className="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                    Make your profile information visible to writers
                                </p>
                            </div>
                            <input
                                type="checkbox"
                                checked={data.profile_visible_to_writers}
                                onChange={(e) => setData("profile_visible_to_writers", e.target.checked)}
                                className="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500"
                            />
                        </label>

                        <label className="flex items-center justify-between">
                            <div>
                                <span className="text-sm font-medium text-gray-900 dark:text-white">
                                    Auto-assign writers
                                </span>
                                <p className="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                    Automatically assign writers to your orders
                                </p>
                            </div>
                            <input
                                type="checkbox"
                                checked={data.auto_assign_writer}
                                onChange={(e) => setData("auto_assign_writer", e.target.checked)}
                                className="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500"
                            />
                        </label>
                    </div>
                </div>

                <div className="p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                    <h4 className="text-sm font-semibold text-gray-900 dark:text-white mb-3">
                        Communication Preferences
                    </h4>
                    <div className="space-y-3">
                        <div>
                            <label className="block text-sm font-medium text-gray-900 dark:text-white mb-2">
                                Preferred Communication Method
                            </label>
                            <select
                                value={data.preferred_communication_method}
                                onChange={(e) => setData("preferred_communication_method", e.target.value)}
                                className="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                            >
                                <option value="in_app">In-App Messaging Only</option>
                                <option value="email">Email Only</option>
                                <option value="both">Both In-App and Email</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div className="p-4 bg-gray-50 dark:bg-gray-700/50 rounded-lg">
                    <h4 className="text-sm font-semibold text-gray-900 dark:text-white mb-3">
                        Invoice Preferences
                    </h4>
                    <div className="space-y-3">
                        <label className="flex items-center justify-between">
                            <div>
                                <span className="text-sm font-medium text-gray-900 dark:text-white">
                                    Auto-send invoices
                                </span>
                                <p className="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                    Automatically send invoices when payments are processed
                                </p>
                            </div>
                            <input
                                type="checkbox"
                                checked={data.auto_send_invoices}
                                onChange={(e) => setData("auto_send_invoices", e.target.checked)}
                                className="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500"
                            />
                        </label>

                        <div>
                            <label className="block text-sm font-medium text-gray-900 dark:text-white mb-2">
                                Invoice Format
                            </label>
                            <select
                                value={data.invoice_format}
                                onChange={(e) => setData("invoice_format", e.target.value)}
                                className="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white"
                            >
                                <option value="pdf">PDF</option>
                                <option value="email">Email</option>
                                <option value="both">Both PDF and Email</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <div className="flex justify-end">
                <PrimaryButton disabled={processing}>
                    {processing ? "Saving..." : "Save Preferences"}
                </PrimaryButton>
            </div>
        </form>
    );
}







