import React from "react";
import { Head } from "@inertiajs/react";
import MainLayout from "@/Layouts/MainLayout";

export default function TermsOfService({ lastUpdated }) {
    return (
        <MainLayout>
            <Head>
                <title>Terms of Service | Academic Scribe</title>
                <meta
                    name="description"
                    content="Terms of Service for Academic Scribe academic writing service. Read our terms and conditions for using our platform and services."
                />
                <meta name="robots" content="index, follow" />
                <link rel="canonical" href={route("terms-of-service")} />
            </Head>

            <div className="min-h-screen bg-gray-50 py-12">
                <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                    {/* Header */}
                    <div className="bg-white rounded-lg shadow-sm p-8 mb-8">
                        <h1 className="text-4xl font-bold text-gray-900 mb-4">
                            Terms of Service
                        </h1>
                        <p className="text-gray-600 text-lg">
                            Last updated: {lastUpdated || "January 1, 2024"}
                        </p>
                        <p className="text-gray-600 mt-4">
                            These Terms of Service govern your use of Supreme
                            Freelancers' academic writing services. By using our
                            platform, you agree to be bound by these terms and
                            conditions.
                        </p>
                    </div>

                    {/* Content */}
                    <div className="bg-white rounded-lg shadow-sm p-8 space-y-8">
                        {/* Acceptance of Terms */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                1. Acceptance of Terms
                            </h2>

                            <p className="text-gray-600 mb-4">
                                By accessing or using Academic Scribe' services,
                                you agree to comply with and be bound by these
                                Terms of Service and our Privacy Policy. If you
                                do not agree with any part of these terms, you
                                may not use our services.
                            </p>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    You must be at least 18 years old to use our
                                    services
                                </li>
                                <li>
                                    You must provide accurate and complete
                                    information
                                </li>
                                <li>
                                    You are responsible for maintaining account
                                    security
                                </li>
                                <li>
                                    You agree to use our services lawfully and
                                    ethically
                                </li>
                            </ul>
                        </section>

                        {/* Service Description */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                2. Service Description
                            </h2>

                            <p className="text-gray-600 mb-4">
                                Academic Scribe provides academic writing
                                assistance and educational support services:
                            </p>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    Custom essay writing and research papers
                                </li>
                                <li>Assignment help and academic guidance</li>
                                <li>Dissertation and thesis assistance</li>
                                <li>Editing and proofreading services</li>
                                <li>Academic tutoring and consultation</li>
                                <li>Research assistance and data analysis</li>
                            </ul>

                            <p className="text-gray-600 mt-4">
                                Our services are intended for educational
                                purposes to help students learn and improve
                                their academic skills.
                            </p>
                        </section>

                        {/* User Responsibilities */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                3. User Responsibilities
                            </h2>

                            <div className="space-y-4">
                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Academic Integrity
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            Use our services as learning aids
                                            and reference materials
                                        </li>
                                        <li>
                                            Understand your institution's
                                            academic integrity policies
                                        </li>
                                        <li>
                                            Properly cite and reference any
                                            assistance received
                                        </li>
                                        <li>
                                            Take responsibility for your
                                            academic submissions
                                        </li>
                                    </ul>
                                </div>

                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Prohibited Uses
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            Submitting our work as your own
                                            without proper attribution
                                        </li>
                                        <li>
                                            Using services for illegal or
                                            unethical purposes
                                        </li>
                                        <li>
                                            Sharing account credentials with
                                            others
                                        </li>
                                        <li>
                                            Attempting to reverse engineer or
                                            copy our platform
                                        </li>
                                        <li>
                                            Harassing writers or support staff
                                        </li>
                                    </ul>
                                </div>

                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Order Requirements
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            Provide clear and complete
                                            assignment instructions
                                        </li>
                                        <li>
                                            Respond promptly to writer
                                            communications
                                        </li>
                                        <li>
                                            Review and approve work within
                                            specified timeframes
                                        </li>
                                        <li>
                                            Request revisions within the allowed
                                            period
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </section>

                        {/* Payment Terms */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                4. Payment Terms
                            </h2>

                            <div className="space-y-4">
                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Pricing and Payment
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            Prices are calculated based on
                                            academic level, deadline, and
                                            complexity
                                        </li>
                                        <li>
                                            Payment is required before work
                                            begins
                                        </li>
                                        <li>
                                            We accept major credit cards,
                                            PayPal, and other secure payment
                                            methods
                                        </li>
                                        <li>
                                            All prices are in USD unless
                                            otherwise specified
                                        </li>
                                    </ul>
                                </div>

                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Refund Policy
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            Full refund if we cannot complete
                                            your order
                                        </li>
                                        <li>
                                            Partial refunds for late delivery
                                            (subject to terms)
                                        </li>
                                        <li>
                                            No refund for completed work that
                                            meets requirements
                                        </li>
                                        <li>
                                            Refund requests must be submitted
                                            within 14 days
                                        </li>
                                        <li>
                                            Refunds processed within 5-10
                                            business days
                                        </li>
                                    </ul>
                                </div>

                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Disputes and Chargebacks
                                    </h3>
                                    <p className="text-gray-600">
                                        Before initiating a chargeback, please
                                        contact our support team to resolve any
                                        issues. Unauthorized chargebacks may
                                        result in account suspension.
                                    </p>
                                </div>
                            </div>
                        </section>

                        {/* Quality Guarantees */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                5. Quality Guarantees
                            </h2>

                            <div className="space-y-4">
                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Our Commitments
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            Original, plagiarism-free content
                                        </li>
                                        <li>
                                            Work completed by qualified writers
                                        </li>
                                        <li>
                                            Adherence to specified requirements
                                            and deadlines
                                        </li>
                                        <li>
                                            Free revisions within 14 days of
                                            delivery
                                        </li>
                                        <li>24/7 customer support</li>
                                    </ul>
                                </div>

                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Revision Policy
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            Unlimited free revisions for 14 days
                                            after delivery
                                        </li>
                                        <li>
                                            Revisions must be within the
                                            original order scope
                                        </li>
                                        <li>
                                            New requirements may incur
                                            additional charges
                                        </li>
                                        <li>
                                            Major changes require approval and
                                            may affect timeline
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </section>

                        {/* Intellectual Property */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                6. Intellectual Property
                            </h2>

                            <div className="space-y-4">
                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Ownership Rights
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            You own the completed work once
                                            payment is processed
                                        </li>
                                        <li>
                                            We retain rights to use anonymized
                                            work for quality control
                                        </li>
                                        <li>
                                            Our platform, tools, and processes
                                            remain our property
                                        </li>
                                        <li>
                                            Writers retain rights to their
                                            general knowledge and skills
                                        </li>
                                    </ul>
                                </div>

                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Copyright Compliance
                                    </h3>
                                    <p className="text-gray-600">
                                        All work is original and does not
                                        infringe on third-party copyrights. We
                                        use proper citations and references for
                                        all sources used in research.
                                    </p>
                                </div>
                            </div>
                        </section>

                        {/* Privacy and Confidentiality */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                7. Privacy and Confidentiality
                            </h2>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    Your personal information is protected
                                    according to our Privacy Policy
                                </li>
                                <li>
                                    All orders and communications are kept
                                    strictly confidential
                                </li>
                                <li>
                                    We do not share client information with
                                    third parties
                                </li>
                                <li>Writers sign confidentiality agreements</li>
                                <li>
                                    Secure data transmission and storage
                                    protocols
                                </li>
                                <li>
                                    Option to delete account and data upon
                                    request
                                </li>
                            </ul>
                        </section>

                        {/* Limitation of Liability */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                8. Limitation of Liability
                            </h2>

                            <p className="text-gray-600 mb-4">
                                Academic Scribe provides services "as is" and
                                makes no warranties beyond those explicitly
                                stated. Our liability is limited as follows:
                            </p>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    Maximum liability limited to the amount paid
                                    for services
                                </li>
                                <li>
                                    No liability for indirect, consequential, or
                                    punitive damages
                                </li>
                                <li>
                                    No responsibility for academic consequences
                                    of service use
                                </li>
                                <li>
                                    Users assume responsibility for compliance
                                    with institutional policies
                                </li>
                                <li>
                                    Force majeure events excuse performance
                                    delays
                                </li>
                            </ul>
                        </section>

                        {/* Account Termination */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                9. Account Termination
                            </h2>

                            <div className="space-y-4">
                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Termination by User
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            You may close your account at any
                                            time
                                        </li>
                                        <li>
                                            Outstanding orders must be completed
                                            or cancelled
                                        </li>
                                        <li>
                                            Account data may be retained for
                                            legal compliance
                                        </li>
                                    </ul>
                                </div>

                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Termination by Academic Scribe
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            We may suspend accounts for terms
                                            violations
                                        </li>
                                        <li>
                                            Fraudulent activity results in
                                            immediate termination
                                        </li>
                                        <li>
                                            Refunds for terminated accounts
                                            handled case-by-case
                                        </li>
                                        <li>
                                            Notice provided when possible before
                                            termination
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </section>

                        {/* Dispute Resolution */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                10. Dispute Resolution
                            </h2>

                            <div className="space-y-4">
                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Resolution Process
                                    </h3>
                                    <ul className="list-disc list-inside text-gray-600 space-y-1">
                                        <li>
                                            Contact customer support for initial
                                            resolution
                                        </li>
                                        <li>
                                            Escalation to management if needed
                                        </li>
                                        <li>
                                            Mediation through neutral third
                                            party if required
                                        </li>
                                        <li>
                                            Binding arbitration as final resort
                                        </li>
                                    </ul>
                                </div>

                                <div>
                                    <h3 className="text-lg font-semibold text-gray-800 mb-2">
                                        Governing Law
                                    </h3>
                                    <p className="text-gray-600">
                                        These terms are governed by the laws of
                                        [Your Jurisdiction]. Any legal
                                        proceedings must be conducted in the
                                        courts of [Your Jurisdiction].
                                    </p>
                                </div>
                            </div>
                        </section>

                        {/* Changes to Terms */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                11. Changes to Terms
                            </h2>

                            <p className="text-gray-600 mb-4">
                                We reserve the right to modify these Terms of
                                Service at any time:
                            </p>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    Changes will be posted on our website with
                                    updated date
                                </li>
                                <li>
                                    Material changes will be communicated via
                                    email
                                </li>
                                <li>
                                    Continued use constitutes acceptance of new
                                    terms
                                </li>
                                <li>
                                    You may terminate your account if you
                                    disagree with changes
                                </li>
                                <li>
                                    Previous terms apply to orders placed before
                                    changes
                                </li>
                            </ul>
                        </section>

                        {/* Force Majeure */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                12. Force Majeure
                            </h2>

                            <p className="text-gray-600 mb-4">
                                We are not liable for delays or failures caused
                                by circumstances beyond our control:
                            </p>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    Natural disasters, pandemics, or emergencies
                                </li>
                                <li>
                                    Government actions, regulations, or
                                    restrictions
                                </li>
                                <li>
                                    Internet outages or technical infrastructure
                                    failures
                                </li>
                                <li>Labor strikes or other work disruptions</li>
                                <li>Acts of terrorism or war</li>
                            </ul>

                            <p className="text-gray-600 mt-4">
                                In such cases, we will make reasonable efforts
                                to minimize disruption and communicate with
                                affected customers.
                            </p>
                        </section>

                        {/* Severability */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                13. Severability
                            </h2>

                            <p className="text-gray-600">
                                If any provision of these Terms of Service is
                                found to be unenforceable or invalid, the
                                remaining provisions will continue in full force
                                and effect. The invalid provision will be
                                replaced with a valid provision that most
                                closely reflects the original intent.
                            </p>
                        </section>

                        {/* Entire Agreement */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                14. Entire Agreement
                            </h2>

                            <p className="text-gray-600">
                                These Terms of Service, together with our
                                Privacy Policy and any other policies referenced
                                herein, constitute the entire agreement between
                                you and Academic Scribe. These terms supersede
                                all prior agreements, communications, and
                                understandings.
                            </p>
                        </section>

                        {/* Contact Information */}
                        <section>
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                15. Contact Information
                            </h2>

                            <p className="text-gray-600 mb-4">
                                If you have questions about these Terms of
                                Service, please contact us:
                            </p>

                            <div className="bg-gray-50 rounded-lg p-6">
                                <div className="space-y-2 text-gray-600">
                                    <div>
                                        <strong>Email:</strong>{" "}
                                        legal@supremefreelancers.com
                                    </div>
                                    <div>
                                        <strong>Support:</strong>{" "}
                                        support@supremefreelancers.com
                                    </div>
                                    <div>
                                        <strong>Phone:</strong> +1 (800)
                                        123-4567
                                    </div>
                                    <div>
                                        <strong>Address:</strong> 123 Academic
                                        Street, Education City, EC 12345
                                    </div>
                                    <div>
                                        <strong>Business Hours:</strong> Monday
                                        - Friday, 9:00 AM - 6:00 PM EST
                                    </div>
                                </div>
                            </div>
                        </section>

                        {/* Acknowledgment */}
                        <section className="bg-blue-50 rounded-lg p-6">
                            <h2 className="text-2xl font-bold text-gray-900 mb-4">
                                Acknowledgment
                            </h2>

                            <p className="text-gray-600 mb-4">
                                By using Academic Scribe' services, you
                                acknowledge that:
                            </p>

                            <ul className="list-disc list-inside text-gray-600 space-y-2">
                                <li>
                                    You have read and understood these Terms of
                                    Service
                                </li>
                                <li>
                                    You agree to be bound by all terms and
                                    conditions
                                </li>
                                <li>
                                    You understand your responsibilities as a
                                    user
                                </li>
                                <li>
                                    You will use our services ethically and
                                    lawfully
                                </li>
                                <li>
                                    You accept the limitations and disclaimers
                                    stated herein
                                </li>
                            </ul>

                            <p className="text-gray-600 mt-4 font-semibold">
                                Thank you for choosing Academic Scribe for your
                                academic writing needs.
                            </p>
                        </section>
                    </div>

                    {/* Footer Navigation */}
                    <div className="mt-8 text-center">
                        <div className="flex flex-wrap justify-center gap-6 text-sm">
                            <a
                                href="/privacy-policy"
                                className="text-blue-600 hover:text-blue-800"
                            >
                                Privacy Policy
                            </a>
                            <a
                                href="/cookie-policy"
                                className="text-blue-600 hover:text-blue-800"
                            >
                                Cookie Policy
                            </a>
                            <a
                                href="/refund-terms-of-service"
                                className="text-blue-600 hover:text-blue-800"
                            >
                                Terms of service
                            </a>
                            <a
                                href="/contact"
                                className="text-blue-600 hover:text-blue-800"
                            >
                                Contact Us
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </MainLayout>
    );
}
