import { useForm, router } from "@inertiajs/react";
import WriterLayout from "@/Layouts/WriterLayout";
import { FormInput } from "@/Components/ui/FormInput";
export default function EditBids({ bid }) {
    const { data, setData, patch, processing, errors } = useForm({
        bid_amount: bid.bid_amount,
        completion_time: bid.completion_time,
        comments: bid.comments, // Change this from bid_comments to comments
    });
    const handleSubmit = (e) => {
        e.preventDefault();

        router.put(route("writer.bids.update", bid.id), data);
    };

    return (
        <WriterLayout>
            <div className="max-w-2xl mx-auto mt-10">
                <div className="bg-white dark:bg-gray-800 rounded-lg shadow-lg">
                    <div className="px-6 py-4 border-b dark:border-gray-700">
                        <h1 className="text-md lg:text-xl font-bold text-blue-500 dark:text-blue-400">
                            Edit Bid
                        </h1>
                    </div>
                    <form onSubmit={handleSubmit} className="p-6 space-y-6">
                        <FormInput
                            id="bid_amount"
                            name="bid_amount"
                            label="Bid Amount"
                            type="number"
                            value={data.bid_amount}
                            setData={setData}
                            error={errors.bid_amount}
                            placeholder="Enter Bid Amount"
                            step="0.01" // This allows decimal input with 2 decimal places
                            min="0.01" // Optional: ensures minimum value
                            required
                        />

                        <div className="mb-4">
                            <label
                                htmlFor="bid_amount"
                                className="block text-sm font-medium text-gray-700 dark:text-gray-300"
                            >
                                Bid Amount
                            </label>
                            <input
                                id="bid_amount"
                                name="bid_amount"
                                type="number"
                                value={data.bid_amount}
                                onChange={(e) =>
                                    setData(
                                        "bid_amount",
                                        e.target.valueAsNumber
                                    )
                                }
                                placeholder="Enter Bid Amount"
                                step="0.01"
                                min="0.01"
                                required
                                className="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm text-gray-900 bg-white dark:bg-gray-800 dark:text-gray-300"
                            />
                            {errors.bid_amount && (
                                <p className="text-sm text-red-500 mt-1">
                                    {errors.bid_amount}
                                </p>
                            )}
                        </div>

                        <FormInput
                            id="completion_time"
                            name="completion_time"
                            label="Completion Time"
                            type="datetime-local"
                            value={data.completion_time}
                            setData={setData}
                            error={errors.completion_time}
                            placeholder="Enter Completion Time"
                            required
                        />

                        <FormInput
                            id="comments" // Change from bid_comments
                            name="comments" // Change from bid_comments
                            label="Bid Comments"
                            type="text"
                            value={data.comments} // Change from data.bid_comments
                            setData={setData}
                            error={errors.comments} // Change from errors.bid_comments
                            placeholder="Enter Bid Comments"
                        />

                        <button
                            type="submit"
                            disabled={processing}
                            className={`${
                                processing ? "opacity-50" : ""
                            } bg-blue-500 hover:bg-blue-600 text-white font-semibold py-2 px-4 rounded`}
                        >
                            {processing ? "Updating..." : "Update Bid"}
                        </button>
                    </form>
                </div>
            </div>
        </WriterLayout>
    );
}
