import { useState } from "react";
import { Head, Link } from "@inertiajs/react";
import WriterLayout from "@/Layouts/WriterLayout";

import {
    CheckCircle,
    Calendar,
    File,
    Clock,
    ArrowRight,
    FileText,
    AlertTriangle,
} from "lucide-react";

export default function Confirmation({ writerProfile, essayTest }) {
    return (
        <WriterLayout>
            <Head title="Essay Submission Confirmation" />

            <div className="py-12">
                <div className="max-w-4xl mx-auto sm:px-6 lg:px-8">
                    <div className="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                        <div className="p-6 bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700">
                            <div className="flex items-center mb-6">
                                <CheckCircle className="h-8 w-8 text-green-500 dark:text-green-400 mr-3" />
                                <h1 className="text-2xl font-bold text-gray-800 dark:text-gray-100">
                                    Essay Submitted Successfully
                                </h1>
                            </div>

                            <div className="mb-8 p-5 bg-green-50 dark:bg-green-900/20 rounded-lg border border-green-200 dark:border-green-800">
                                <p className="text-green-700 dark:text-green-300">
                                    Your essay has been successfully submitted
                                    and will be reviewed by our team. You'll be
                                    notified once the evaluation is complete.
                                </p>

                                {essayTest.autoProcessed && (
                                    <div className="mt-3 flex items-start">
                                        <AlertTriangle className="h-5 w-5 text-amber-500 dark:text-amber-400 mr-2 flex-shrink-0 mt-0.5" />
                                        <p className="text-sm text-amber-600 dark:text-amber-300">
                                            Note: Your submission was
                                            automatically processed as the test
                                            time expired.
                                        </p>
                                    </div>
                                )}
                            </div>

                            <div className="bg-gray-50 dark:bg-gray-700/50 rounded-lg p-5 mb-8">
                                <h2 className="text-lg font-semibold text-gray-700 dark:text-gray-200 mb-4">
                                    Submission Details
                                </h2>

                                <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <div className="flex items-start">
                                        <Calendar className="h-5 w-5 text-blue-500 dark:text-blue-400 mr-2 flex-shrink-0 mt-0.5" />
                                        <div>
                                            <p className="text-sm text-gray-500 dark:text-gray-400">
                                                Submitted On
                                            </p>
                                            <p className="text-gray-800 dark:text-gray-200">
                                                {essayTest.submittedAt}
                                            </p>
                                        </div>
                                    </div>

                                    <div className="flex items-start">
                                        <File className="h-5 w-5 text-blue-500 dark:text-blue-400 mr-2 flex-shrink-0 mt-0.5" />
                                        <div>
                                            <p className="text-sm text-gray-500 dark:text-gray-400">
                                                File Submitted
                                            </p>
                                            <p className="text-gray-800 dark:text-gray-200">
                                                {essayTest.fileName}
                                            </p>
                                            <p className="text-xs text-gray-500 dark:text-gray-400">
                                                {essayTest.fileSize}
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div className="bg-blue-50 dark:bg-blue-900/20 rounded-lg p-5 mb-8">
                                <h2 className="text-lg font-semibold text-blue-700 dark:text-blue-300 mb-3 flex items-center">
                                    <FileText className="h-5 w-5 mr-2" />
                                    What Happens Next?
                                </h2>

                                <ul className="space-y-3 text-blue-600 dark:text-blue-400">
                                    <li className="flex items-start">
                                        <span className="inline-flex items-center justify-center h-5 w-5 rounded-full bg-blue-100 dark:bg-blue-800 text-blue-600 dark:text-blue-300 text-xs font-medium mr-2 flex-shrink-0 mt-0.5">
                                            1
                                        </span>
                                        <span>
                                            Our team will review your essay for
                                            quality, structure, and adherence to
                                            requirements.
                                        </span>
                                    </li>
                                    <li className="flex items-start">
                                        <span className="inline-flex items-center justify-center h-5 w-5 rounded-full bg-blue-100 dark:bg-blue-800 text-blue-600 dark:text-blue-300 text-xs font-medium mr-2 flex-shrink-0 mt-0.5">
                                            2
                                        </span>
                                        <span>
                                            You'll receive an email notification
                                            once the evaluation is complete.
                                        </span>
                                    </li>
                                    <li className="flex items-start">
                                        <span className="inline-flex items-center justify-center h-5 w-5 rounded-full bg-blue-100 dark:bg-blue-800 text-blue-600 dark:text-blue-300 text-xs font-medium mr-2 flex-shrink-0 mt-0.5">
                                            3
                                        </span>
                                        <span>
                                            If your essay meets our standards,
                                            you'll be approved as a writer on
                                            our platform.
                                        </span>
                                    </li>
                                </ul>
                            </div>

                            <div className="mt-8 flex justify-end">
                                <Link href={route("writer.dashboard")}>
                                    <span className="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-md font-semibold text-sm hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                                        Return to Dashboard
                                        <ArrowRight className="ml-2 h-4 w-4" />
                                    </span>
                                </Link>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </WriterLayout>
    );
}
