import { Head, Link } from "@inertiajs/react";
import WriterLayout from "@/Layouts/WriterLayout";
import PrimaryButton from "@/Components/PrimaryButton";
import { CheckCircle, Clock, FileText } from "lucide-react";

export default function TestInstructions({
    canTakeTest,
    waitingPeriod,
    daysRemaining,
    retryDate,
    totalQuestionsInPool,
    testQuestionCount,
    passingPercentage,
    passingScore,
    previousAttempt,
    testDuration,
}) {
    return (
        <WriterLayout>
            <Head title="Writer Qualification Test - Instructions" />

            <div className="py-12">
                <div className="max-w-4xl mx-auto sm:px-6 lg:px-8">
                    <div className="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                        <div className="p-6 bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700">
                            <h1 className="text-2xl font-bold text-gray-800 dark:text-gray-100 mb-6">
                                Writer Qualification Test - Instructions
                            </h1>

                            {waitingPeriod && (
                                <div className="mb-6 p-4 bg-yellow-50 dark:bg-yellow-900/20 border-l-4 border-yellow-400 dark:border-yellow-500 text-yellow-700 dark:text-yellow-300">
                                    <div className="flex">
                                        <div className="flex-shrink-0">
                                            <CalendarIcon
                                                className="h-5 w-5 text-yellow-400 dark:text-yellow-300"
                                                aria-hidden="true"
                                            />
                                        </div>
                                        <div className="ml-3">
                                            <p className="text-sm">
                                                <strong>Waiting Period:</strong>{" "}
                                                You must wait {daysRemaining}{" "}
                                                more days before retrying the
                                                test.
                                            </p>
                                            <p className="text-sm mt-1">
                                                You can retry on{" "}
                                                <strong>{retryDate}</strong>.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            )}

                            {previousAttempt && (
                                <div className="mb-6 p-4 bg-gray-50 dark:bg-gray-700/50 border border-gray-200 dark:border-gray-600 rounded-md">
                                    <h2 className="text-lg font-semibold text-gray-700 dark:text-gray-200 mb-2">
                                        Previous Attempt
                                    </h2>
                                    <div className="flex items-center">
                                        <div className="mr-4">
                                            <span className="text-sm text-gray-500 dark:text-gray-400">
                                                Score:
                                            </span>
                                            <span className="ml-2 text-lg font-medium text-gray-900 dark:text-gray-100">
                                                {Math.round(
                                                    previousAttempt.score
                                                )}
                                                %
                                            </span>
                                        </div>
                                        <div>
                                            <span className="text-sm text-gray-500 dark:text-gray-400">
                                                Date:
                                            </span>
                                            <span className="ml-2 text-lg font-medium text-gray-900 dark:text-gray-100">
                                                {previousAttempt.date}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            )}

                            <div className="space-y-6">
                                <div>
                                    <h2 className="text-lg font-semibold text-gray-700 dark:text-gray-200">
                                        Test Overview
                                    </h2>
                                    <p className="mt-1 text-gray-600 dark:text-gray-300">
                                        This multiple-choice test evaluates your
                                        knowledge and skills as a writer. It's
                                        the first step in our qualification
                                        process.
                                    </p>
                                </div>

                                <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
                                    <div className="p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg">
                                        <div className="flex items-center mb-2">
                                            <FileText className="h-5 w-5 text-blue-500 dark:text-blue-400 mr-2" />
                                            <h3 className="font-medium text-blue-700 dark:text-blue-300">
                                                Questions
                                            </h3>
                                        </div>
                                        <p className="text-sm text-blue-600 dark:text-blue-300">
                                            {testQuestionCount} multiple-choice
                                            questions selected from a pool of{" "}
                                            {totalQuestionsInPool} questions.
                                        </p>
                                    </div>

                                    <div className="p-4 bg-purple-50 dark:bg-purple-900/20 rounded-lg">
                                        <div className="flex items-center mb-2">
                                            <Clock className="h-5 w-5 text-purple-500 dark:text-purple-400 mr-2" />
                                            <h3 className="font-medium text-purple-700 dark:text-purple-300">
                                                Time Limit
                                            </h3>
                                        </div>
                                        <p className="text-sm text-purple-600 dark:text-purple-300">
                                            {testDuration} minutes to complete
                                            the test. The test will auto-submit
                                            when time expires.
                                        </p>
                                    </div>

                                    <div className="p-4 bg-green-50 dark:bg-green-900/20 rounded-lg">
                                        <div className="flex items-center mb-2">
                                            <CheckCircle className="h-5 w-5 text-green-500 dark:text-green-400 mr-2" />
                                            <h3 className="font-medium text-green-700 dark:text-green-300">
                                                Passing Score
                                            </h3>
                                        </div>
                                        <p className="text-sm text-green-600 dark:text-green-300">
                                            {passingPercentage}% ({passingScore}{" "}
                                            out of {testQuestionCount} questions
                                            correct)
                                        </p>
                                    </div>
                                </div>

                                <div>
                                    <h2 className="text-lg font-semibold text-gray-700 dark:text-gray-200">
                                        Test Rules
                                    </h2>
                                    <ul className="mt-2 space-y-2 text-gray-600 dark:text-gray-300 list-disc list-inside">
                                        <li>
                                            Once you start the test, you cannot
                                            pause or restart it.
                                        </li>
                                        <li>
                                            You must complete the test in one
                                            sitting.
                                        </li>
                                        <li>
                                            Each question has only one correct
                                            answer.
                                        </li>
                                        <li>
                                            You can review and change your
                                            answers before submitting.
                                        </li>
                                        <li>
                                            If you fail the test, you must wait
                                            3 months before retrying.
                                        </li>
                                        <li>
                                            If you pass, you'll proceed to the
                                            essay test.
                                        </li>
                                    </ul>
                                </div>

                                <div>
                                    <h2 className="text-lg font-semibold text-gray-700 dark:text-gray-200">
                                        Security Measures
                                    </h2>
                                    <ul className="mt-2 space-y-2 text-gray-600 dark:text-gray-300 list-disc list-inside">
                                        <li>
                                            Your test session is monitored for
                                            security purposes.
                                        </li>
                                        <li>
                                            Refreshing the page or opening
                                            multiple tabs may result in test
                                            invalidation.
                                        </li>
                                        <li>
                                            The system tracks your activity
                                            throughout the test.
                                        </li>
                                        <li>
                                            Ensure you have a stable internet
                                            connection before starting.
                                        </li>
                                    </ul>
                                </div>

                                <div>
                                    <h2 className="text-lg font-semibold text-gray-700 dark:text-gray-200">
                                        Test Categories
                                    </h2>
                                    <p className="mt-1 text-gray-600 dark:text-gray-300">
                                        The test covers various aspects of
                                        writing, including:
                                    </p>
                                    <ul className="mt-2 space-y-1 text-gray-600 dark:text-gray-300 list-disc list-inside">
                                        <li>Grammar and punctuation</li>
                                        <li>Vocabulary and word choice</li>
                                        <li>
                                            Citation styles (APA, MLA, Chicago)
                                        </li>
                                        <li>Research methodology</li>
                                        <li>Academic writing standards</li>
                                    </ul>
                                </div>

                                <div className="pt-4 border-t border-gray-200 dark:border-gray-700">
                                    <h2 className="text-lg font-semibold text-gray-700 dark:text-gray-200">
                                        Ready to Begin?
                                    </h2>
                                    <p className="mt-1 text-gray-600 dark:text-gray-300">
                                        Make sure you have a stable internet
                                        connection and {testDuration} minutes of
                                        uninterrupted time.
                                    </p>
                                    <div className="mt-6 flex justify-end">
                                        <Link href={route("writer.dashboard")}>
                                            <span className="inline-flex items-center px-4 py-2 bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded-md font-semibold text-xs text-gray-700 dark:text-gray-300 uppercase tracking-widest shadow-sm hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-indigo-500 dark:focus:ring-indigo-400 focus:ring-offset-2 dark:focus:ring-offset-gray-800 disabled:opacity-25 transition ease-in-out duration-150 mr-3">
                                                Return to Dashboard
                                            </span>
                                        </Link>

                                        {canTakeTest ? (
                                            <Link
                                                href={route(
                                                    "writer.test.start"
                                                )}
                                                method="post"
                                                className="inline-flex items-center rounded-md border border-transparent bg-gray-800 dark:bg-gray-700 px-4 py-2 text-xs font-semibold uppercase tracking-widest text-white transition duration-150 ease-in-out hover:bg-gray-700 dark:hover:bg-gray-600 focus:bg-gray-700 dark:focus:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-indigo-500 dark:focus:ring-indigo-400 focus:ring-offset-2 dark:focus:ring-offset-gray-800 active:bg-gray-900 dark:active:bg-gray-800"
                                            >
                                                Start Test
                                            </Link>
                                        ) : (
                                            <button
                                                disabled
                                                className="inline-flex items-center rounded-md border border-transparent bg-gray-800 dark:bg-gray-700 px-4 py-2 text-xs font-semibold uppercase tracking-widest text-white transition duration-150 ease-in-out hover:bg-gray-700 dark:hover:bg-gray-600 focus:bg-gray-700 dark:focus:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-indigo-500 dark:focus:ring-indigo-400 focus:ring-offset-2 dark:focus:ring-offset-gray-800 active:bg-gray-900 dark:active:bg-gray-800 opacity-25 cursor-not-allowed"
                                            >
                                                {waitingPeriod
                                                    ? "Waiting Period Active"
                                                    : "Test Unavailable"}
                                            </button>
                                        )}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </WriterLayout>
    );
}
