export const ALLOWED_FILE_TYPES = {
    // Microsoft Word
    "application/msword": ".doc",
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document":
        ".docx",

    // Microsoft Excel
    "application/vnd.ms-excel": ".xls",
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet":
        ".xlsx",

    // Microsoft PowerPoint
    "application/vnd.ms-powerpoint": ".ppt",
    "application/vnd.openxmlformats-officedocument.presentationml.presentation":
        ".pptx",

    // PDF
    "application/pdf": ".pdf",

    // ZIP
    "application/zip": ".zip",
    "application/x-zip-compressed": ".zip",
};

export const MAX_FILE_SIZE = 25 * 1024 * 1024; // 25MB in bytes

export const isAllowedFileType = (file) => {
    if (!file || !file.type) return false;
    return Object.keys(ALLOWED_FILE_TYPES).includes(file.type);
};

export const getReadableFileSize = (bytes) => {
    if (bytes === 0) return "0 Bytes";
    const sizes = ["Bytes", "KB", "MB", "GB"];
    const i = Math.floor(Math.log(bytes) / Math.log(1024));
    return `${parseFloat((bytes / Math.pow(1024, i)).toFixed(2))} ${sizes[i]}`;
};
