<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- Primary Meta Tags -->
    <title>{{ $meta['title'] }}</title>
    <meta name="title" content="{{ $meta['title'] }}">
    <meta name="description" content="{{ $meta['description'] }}">
    <meta name="keywords" content="{{ $meta['keywords'] }}">
    
    <!-- Canonical URL -->
    <link rel="canonical" href="{{ $meta['canonical'] }}">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="{{ $meta['og_type'] }}">
    <meta property="og:url" content="{{ $meta['og_url'] }}">
    <meta property="og:title" content="{{ $meta['og_title'] }}">
    <meta property="og:description" content="{{ $meta['og_description'] }}">
    <meta property="og:image" content="{{ $meta['og_image'] }}">
    <meta property="og:site_name" content="{{ config('app.name') }}">
    
    <!-- Twitter -->
    <meta name="twitter:card" content="{{ $meta['twitter_card'] }}">
    <meta name="twitter:url" content="{{ $url }}">
    <meta name="twitter:title" content="{{ $meta['twitter_title'] ?: $meta['title'] }}">
    <meta name="twitter:description" content="{{ $meta['twitter_description'] ?: $meta['description'] }}">
    <meta name="twitter:image" content="{{ $meta['twitter_image'] }}">
    
    <!-- Structured Data -->
    @if(!empty($meta['structured_data']))
        @if(is_string($meta['structured_data']))
            <script type="application/ld+json">{!! $meta['structured_data'] !!}</script>
        @elseif(is_array($meta['structured_data']) || is_object($meta['structured_data']))
            <script type="application/ld+json">{!! json_encode($meta['structured_data'], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}</script>
        @endif
    @endif
    
    <!-- Basic Styles for Crawlers -->
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        h1 { color: #1a73e8; }
        .crawler-notice {
            background: #f0f0f0;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
    </style>
</head>
<body>
    <div class="crawler-notice">
        <h1>{{ $meta['title'] }}</h1>
        <p>{{ $meta['description'] }}</p>
        <p><strong>Note:</strong> This is a crawler-optimized view. For the full interactive experience, please visit with a web browser.</p>
        <p><a href="{{ $url }}">View Full Site</a></p>
    </div>
    
    <script>
        // If JavaScript is enabled (shouldn't be for crawlers), redirect to full site
        window.location.href = "{{ $url }}";
    </script>
</body>
</html>
