<?php

use Inertia\Inertia;

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BidsController;

use App\Http\Controllers\AdminController;
use App\Http\Controllers\OrdersController;
use App\Http\Controllers\PayPalController;
use App\Http\Controllers\StripeController;
use App\Http\Controllers\WriterController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\SitemapController;
use App\Http\Controllers\SubjectsController;
use App\Http\Controllers\AdminUserController;
use App\Http\Controllers\ClientBidController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\UrgenciesController;
use App\Http\Controllers\OrderFilesController;
use App\Http\Controllers\PaperTypesController;
use App\Http\Controllers\AdminOrdersController;
use App\Http\Controllers\AdminSettingController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\AcademicLevelsController;
use App\Http\Controllers\CurrencyController;
use App\Http\Controllers\Writer\WriterTestController;
use App\Http\Controllers\Admin\TestQuestionController;
use App\Http\Controllers\Writer\WriterEssayController;
use App\Http\Controllers\Writer\WriterProfileController;
use App\Http\Controllers\Webhooks\PayPalWebhookController;
use App\Http\Controllers\Webhooks\StripeWebhookController;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;

// Broadcasting authentication route for Laravel Echo - MUST BE FIRST
Route::post('/broadcasting/auth', function () {
    \Log::info('Broadcasting auth route hit', [
        'user_authenticated' => auth()->check(),
        'user_id' => auth()->id(),
        'user_type' => auth()->check() ? auth()->user()->user_type : null,
        'request_data' => request()->all(),
        'headers' => request()->headers->all(),
        'session_id' => session()->getId(),
        'cookies' => request()->cookies->all()
    ]);
    
    try {
        // Ensure the user is authenticated
        if (!auth()->check()) {
            \Log::warning('Broadcasting authentication failed: User not authenticated');
            return response()->json(['error' => 'Unauthenticated'], 401);
        }
        
        // Get the broadcast controller and authenticate
        $controller = app(\Illuminate\Broadcasting\BroadcastController::class);
        $response = $controller->authenticate(request());
        
        \Log::info('Broadcasting authentication successful', [
            'user_id' => auth()->id(),
            'user_type' => auth()->user()->user_type,
            'channel_name' => request()->input('channel_name')
        ]);
        
        return $response;
    } catch (\Exception $e) {
        \Log::error('Broadcasting authentication error: ' . $e->getMessage(), [
            'user_id' => auth()->id(),
            'user_type' => auth()->check() ? auth()->user()->user_type : null,
            'request_data' => request()->all(),
            'trace' => $e->getTraceAsString()
        ]);
        return response()->json(['error' => 'Authentication failed: ' . $e->getMessage()], 403);
    }
})->middleware(['web'])->name('broadcasting.auth');

Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::get('/pricing-page', [App\Http\Controllers\PricingController::class, 'index'])->name('pricing-page');

Route::get('/guarantees', [App\Http\Controllers\GuaranteesController::class, 'index'])->name('guarantees');

Route::get('/writers', [App\Http\Controllers\WritersController::class, 'index'])->name('writers');

Route::get('/privacy-policy', [App\Http\Controllers\PrivacyPolicyController::class, 'index'])->name('privacy-policy');

Route::get('/terms-of-service', [App\Http\Controllers\TermsOfServiceController::class, 'index'])->name('terms-of-service');

Route::get('/cookie-policy', [App\Http\Controllers\CookiePolicyController::class, 'index'])->name('cookie-policy');

Route::get('/about', [App\Http\Controllers\AboutController::class, 'index'])->name('about');

Route::get('/contact', [App\Http\Controllers\ContactController::class, 'index'])->name('contact');
Route::post('/contact', [App\Http\Controllers\ContactController::class, 'store'])->name('contact.store');

Route::get('/reviews', [App\Http\Controllers\ReviewsController::class, 'index'])->name('reviews');

Route::prefix('services')->name('services.')->group(function () {
    // Main services index page
    Route::get('/', [ServiceController::class, 'index'])->name('index');

    // Individual service pages with consistent naming
    Route::get('/essay-writing', [ServiceController::class, 'essays'])->name('essay-writing');
    Route::get('/research-papers', [ServiceController::class, 'researchPapers'])->name('research-papers');
    Route::get('/dissertation-writing', [ServiceController::class, 'dissertations'])->name('dissertation-writing');
    Route::get('/assignments', [ServiceController::class, 'assignments'])->name('assignments');
    Route::get('/case-studies', [ServiceController::class, 'casestudies'])->name('case-studies');
    Route::get('/literature-reviews', [ServiceController::class, 'literatureReviews'])->name('literature-reviews');
    Route::get('/thesis-proposals', [ServiceController::class, 'thesisProposals'])->name('thesis-proposals');
    Route::get('/personal-statements', [ServiceController::class, 'personalStatements'])->name('personal-statements');
    Route::get('/programming-assignments', [ServiceController::class, 'programmingAssignments'])->name('programming-assignments');
    // New buy-intent service pages
    Route::get('/affordable-essay-writing', [ServiceController::class, 'affordableEssayWriting'])->name('affordable-essay-writing');
    Route::get('/buy-essays-online', [ServiceController::class, 'buyEssayWriting'])->name('buy-essays-online');
    Route::get('/cheap-essays-online', [ServiceController::class, 'cheapEssayWriting'])->name('cheap-essays-online');
    
    // Catch-all route for dynamically created service pages (must be last)
    Route::get('/{slug}', [ServiceController::class, 'show'])->name('show');
});

// Legacy redirects for SEO preservation
Route::redirect('/research-papers', '/services/research-papers', 301);
Route::redirect('/dissertation-writing', '/services/dissertation-writing', 301);
Route::redirect('/essay-writing', '/services/essay-writing', 301);
Route::redirect('/assignments', '/services/assignments', 301);
Route::redirect('/case-studies', '/services/case-studies', 301);
Route::redirect('/literature-reviews', '/services/literature-reviews', 301);
Route::redirect('/thesis-proposals', '/services/thesis-proposals', 301);

// Legacy buy-intent redirects
Route::redirect('/services/buy-essay-writing', '/services/buy-essays-online', 301);
Route::redirect('/services/cheap-essay-writing', '/services/cheap-essays-online', 301);



// Add these routes to your existing web.php file or create separate API routes

// Blog Upload Routes (add these to your existing routes)
Route::middleware(['auth', 'verified'])->prefix('blog/upload')->name('blog.upload.')->group(function () {
    // Upload blog files
    Route::post('/', [App\Http\Controllers\BlogUploadController::class, 'upload'])
        ->middleware('validate.blog.upload')
        ->name('files');

    // Get upload status
    Route::get('/{uploadId}/status', [App\Http\Controllers\BlogUploadController::class, 'getUploadStatus'])
        ->name('status');

    // Delete upload
    Route::delete('/{uploadId}', [App\Http\Controllers\BlogUploadController::class, 'deleteUpload'])
        ->name('delete');

    // Get upload progress
    Route::get('/{uploadId}/progress', [App\Http\Controllers\BlogUploadController::class, 'getUploadProgress'])
        ->name('progress');
});

// Blog Processing Routes (add these to your existing routes)
Route::middleware(['auth', 'verified'])->prefix('blog/process')->name('blog.process.')->group(function () {
    // Process uploaded files
    Route::post('/files', [App\Http\Controllers\BlogProcessingController::class, 'processFiles'])
        ->name('files');

    // Import processed files to database
    Route::post('/import', [App\Http\Controllers\BlogProcessingController::class, 'importFiles'])
        ->name('import');

    // Get processing status
    Route::get('/{uploadId}/status', [App\Http\Controllers\BlogProcessingController::class, 'getProcessingStatus'])
        ->name('status');

    // Get import statistics
    Route::get('/{uploadId}/stats', [App\Http\Controllers\BlogProcessingController::class, 'getImportStats'])
        ->name('stats');

    // Process and import in one operation
    Route::post('/process-and-import', [App\Http\Controllers\BlogProcessingController::class, 'processAndImport'])
        ->name('process-and-import');

    // Get processed file content
    Route::get('/{uploadId}/file/{filename}', [App\Http\Controllers\BlogProcessingController::class, 'getProcessedFile'])
        ->name('file');

    // Clean up upload files
    Route::delete('/{uploadId}/cleanup', [App\Http\Controllers\BlogProcessingController::class, 'cleanupUpload'])
        ->name('cleanup');

    Route::post('/reprocess-related-posts', [App\Http\Controllers\BlogProcessingController::class, 'reprocessRelatedPosts'])
        ->name('reprocess-related-posts');

    // Reprocess related posts for all uploads
    Route::post('/reprocess-all-related-posts', [App\Http\Controllers\BlogProcessingController::class, 'reprocessAllRelatedPosts'])
        ->name('reprocess-all-related-posts');

    // Get related posts statistics
    Route::get('/{uploadId}/related-posts-stats', [App\Http\Controllers\BlogProcessingController::class, 'getRelatedPostsStats'])
        ->name('related-posts-stats');

    // Check related posts database status
    Route::get('/related-posts-status', [App\Http\Controllers\BlogProcessingController::class, 'checkRelatedPostsStatus'])
        ->name('related-posts-status');
});


// Replace the existing Blog Admin Routes section with this:
Route::middleware(['auth', 'verified', 'admin'])->prefix('admin/blog')->name('admin.blog.')->group(function () {
    // Blog Dashboard
    Route::get('/', [App\Http\Controllers\Admin\BlogController::class, 'dashboard'])
        ->name('dashboard');

    // Blog Posts Management
    Route::get('/posts', [App\Http\Controllers\Admin\BlogController::class, 'posts'])->name('posts');
    Route::get('/posts/create', [App\Http\Controllers\Admin\BlogController::class, 'createPost'])->name('posts.create');
    Route::post('/posts', [App\Http\Controllers\Admin\BlogController::class, 'storePost'])->name('posts.store');
    Route::get('/posts/{id}/edit', [App\Http\Controllers\Admin\BlogController::class, 'editPost'])->name('posts.edit');
    Route::put('/posts/{id}', [App\Http\Controllers\Admin\BlogController::class, 'updatePost'])->name('posts.update');
    Route::delete('/posts/{id}', [App\Http\Controllers\Admin\BlogController::class, 'deletePost'])->name('posts.destroy');

    // Blog Categories Management
    Route::get('/categories', [App\Http\Controllers\Admin\BlogController::class, 'categories'])
        ->name('categories');
    Route::post('/categories', [App\Http\Controllers\Admin\BlogController::class, 'storeCategory'])
        ->name('categories.store');
    Route::put('/categories/{category}', [App\Http\Controllers\Admin\BlogController::class, 'updateCategory'])
        ->name('categories.update');
    Route::delete('/categories/{category}', [App\Http\Controllers\Admin\BlogController::class, 'deleteCategory'])
        ->name('categories.destroy');

    // Blog Authors Management
    Route::get('/authors', [App\Http\Controllers\Admin\BlogController::class, 'authors'])
        ->name('authors');
    Route::post('/authors', [App\Http\Controllers\Admin\BlogController::class, 'storeAuthor'])
        ->name('authors.store');
    Route::put('/authors/{author}', [App\Http\Controllers\Admin\BlogController::class, 'updateAuthor'])
        ->name('authors.update');
    Route::delete('/authors/{author}', [App\Http\Controllers\Admin\BlogController::class, 'deleteAuthor'])
        ->name('authors.destroy');

    // Blog Tags Management
    Route::get('/tags', [App\Http\Controllers\Admin\BlogController::class, 'tags'])
        ->name('tags');
    Route::post('/tags', [App\Http\Controllers\Admin\BlogController::class, 'storeTag'])
        ->name('tags.store');
    Route::put('/tags/{tag}', [App\Http\Controllers\Admin\BlogController::class, 'updateTag'])
        ->name('tags.update');
    Route::delete('/tags/{tag}', [App\Http\Controllers\Admin\BlogController::class, 'deleteTag'])
        ->name('tags.destroy');

    // Blog Upload Interface
    Route::get('/upload', [App\Http\Controllers\Admin\BlogController::class, 'upload'])
        ->name('upload');

    // Image Upload
    Route::post('/upload-featured-image', [App\Http\Controllers\Admin\BlogController::class, 'uploadFeaturedImage'])
        ->name('upload-featured-image');
    
    // SEO Image Upload
    Route::post('/upload-seo-image', [App\Http\Controllers\Admin\BlogController::class, 'uploadSeoImage'])
        ->name('upload-seo-image');

    // Bulk Operations
    Route::post('/posts/bulk-action', [App\Http\Controllers\Admin\BlogController::class, 'bulkAction'])
        ->name('posts.bulk');
});







Route::prefix('blog')->name('blog.')->group(function () {
    // Your existing routes
    Route::get('/', [App\Http\Controllers\BlogController::class, 'index'])->name('index');
    Route::get('/category/{category}', [App\Http\Controllers\BlogController::class, 'category'])->name('category');
    Route::get('/{slug}', [App\Http\Controllers\BlogController::class, 'show'])->name('show');


    // Additional API routes for enhanced functionality
    Route::get('/api/posts', [App\Http\Controllers\BlogController::class, 'apiPosts'])->name('api.posts');
    Route::get('/api/posts/{slug}', [App\Http\Controllers\BlogController::class, 'apiPost'])->name('api.post');
    // Route::post('/newsletter/subscribe', [App\Http\Controllers\BlogController::class, 'subscribe'])->name('newsletter.subscribe');
});

// Sitemap routes
Route::get('/sitemap.xml', [SitemapController::class, 'index'])->name('sitemap');
Route::get('/sitemap-blog.xml', [SitemapController::class, 'blogSitemap'])->name('sitemap.blog');
Route::get('/sitemap-news.xml', [SitemapController::class, 'newsSitemap'])->name('sitemap.news');
Route::get('/sitemap-images.xml', [SitemapController::class, 'imageSitemap'])->name('sitemap.images');
Route::get('/sitemap-index.xml', [SitemapController::class, 'sitemapIndex'])->name('sitemap.index');
Route::get('/robots.txt', [SitemapController::class, 'robots'])->name('robots');


Route::prefix('api/images')->name('api.images.')->group(function () {
    Route::get('/optimize', [App\Http\Controllers\ImageController::class, 'getOptimizedImage'])
        ->name('optimize');
    Route::post('/batch-optimize', [App\Http\Controllers\ImageController::class, 'getBatchOptimizedImages'])
        ->name('batch-optimize');
    Route::post('/convert-static', [App\Http\Controllers\ImageController::class, 'convertStaticImage'])
        ->name('convert-static')
        ->middleware(['auth', 'admin']); // Only admins can convert static images
});


Route::get('/inactive', function () {
    return Inertia::render('Auth/Inactive', [
        'message' => session('message'),
    ]);
})->name('inactive');

//Dashboard for clients
Route::get('/dashboard', [DashboardController::class, 'index'])
    ->middleware(['auth', 'verified', 'client'])
    ->name('dashboard');

//client profile routes
Route::middleware('auth', 'client', 'verified')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::put('/profile', [App\Http\Controllers\Writer\WriterProfileController::class, 'update'])
        ->name('profile.update');

    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
    // Client settings routes
    Route::get('/settings', [App\Http\Controllers\ClientSettingsController::class, 'index'])->name('settings.index');
    Route::post('/settings/notifications', [App\Http\Controllers\ClientSettingsController::class, 'updateNotifications'])->name('settings.notifications.update');
    Route::post('/settings/preferences', [App\Http\Controllers\ClientSettingsController::class, 'updatePreferences'])->name('settings.preferences.update');
    Route::post('/settings/billing', [App\Http\Controllers\ClientSettingsController::class, 'updateBilling'])->name('settings.billing.update');
});

//Client Orders Routes

// Public order form access (no authentication required for initial steps)
Route::get('/place-order', [OrdersController::class, 'create'])->name('order.create');

// Order context storage (requires CSRF protection)
Route::post('/store-order-context', [OrdersController::class, 'storeOrderContext'])
    ->name('order.store-context')
    ->middleware('web'); // Ensure web middleware is applied for session handling

// CSRF token endpoint - returns current session token without rotation
// Only used for defensive recovery from 419 errors
Route::get('/csrf-token', function () {
    return response()->json(['token' => session()->token()]);
})->middleware('web')->name('csrf.token');

// Anonymous pricing routes (no authentication required)
Route::post('/calculate-pricing', [OrdersController::class, 'calculateAnonymousPricing'])->name('orders.calculate-pricing');
Route::get('/discount-info', [OrdersController::class, 'getDiscountInformation'])->name('orders.discount-info');

// Secure backend pricing calculation (excluded from CSRF for anonymous access)
Route::post('/calculate-order-pricing', [OrdersController::class, 'calculateOrderPricing'])
    ->withoutMiddleware([\Illuminate\Foundation\Http\Middleware\VerifyCsrfToken::class])
    ->name('orders.calculate-order-pricing');

// Authenticated order routes (require login)
Route::middleware('auth', 'client', 'verified')->group(function () {
    Route::post('/orders', [OrdersController::class, 'store'])->name('orders.store')->withoutMiddleware([\Illuminate\Foundation\Http\Middleware\ValidateCsrfToken::class]);
    Route::get('/orders/{order}', [OrdersController::class, 'show'])->name('orders.show');
    Route::get('/orders', [OrdersController::class, 'index'])->name('orders.index');
    Route::delete('/orders/{order}', [OrdersController::class, 'destroy'])->name('orders.destroy');
    Route::post('/validate-coupon', [OrdersController::class, 'validateCoupon'])
        ->name('validate.coupon');
});



//client bid accept routes
Route::middleware(['auth', 'client', 'verified'])->group(function () {
    Route::get('/client/bids', [ClientBidController::class, 'index'])->name('client.bids.index');
    Route::post('/orders/{order}/bids/{bid}/accept', [ClientBidController::class, 'acceptBid']);
    Route::get('/api/writer-details/{writerId}', [OrdersController::class, 'getWriterDetails'])
        ->name('writer.details');
    
    // Order approval routes
    Route::get('/orders/{order}/approve', [App\Http\Controllers\Client\OrderApprovalController::class, 'showApprovalInterface'])
        ->name('orders.approve');
    Route::post('/orders/{order}/approve', [App\Http\Controllers\Client\OrderApprovalController::class, 'approveOrder'])
        ->name('orders.approve.store');
    Route::post('/orders/{order}/revision', [App\Http\Controllers\Client\OrderApprovalController::class, 'requestRevision'])
    ->name('orders.revision.store');
Route::get('/orders/{order}/timeline', [App\Http\Controllers\Client\OrderApprovalController::class, 'getOrderTimeline'])
    ->name('orders.timeline');

// Client Revision Routes
Route::prefix('orders/{order}')->name('client.')->group(function () {
    Route::get('/revisions', [App\Http\Controllers\Client\ClientRevisionController::class, 'index'])->name('revisions.index');
    Route::get('/revisions/create', [App\Http\Controllers\Client\ClientRevisionController::class, 'create'])->name('revisions.create');
    Route::post('/revisions', [App\Http\Controllers\Client\ClientRevisionController::class, 'store'])->name('revisions.store');
    Route::get('/revisions/{revision}', [App\Http\Controllers\Client\ClientRevisionController::class, 'show'])->name('revisions.show');
});

// Client Revision Dashboard
Route::get('/revisions/dashboard', [App\Http\Controllers\Client\ClientRevisionController::class, 'dashboard'])
    ->name('client.revisions.dashboard');

// Client Projects Routes
Route::get('/projects/completed', [App\Http\Controllers\ProjectsController::class, 'completed'])->name('projects.completed');
Route::get('/projects/active', [App\Http\Controllers\ProjectsController::class, 'active'])->name('projects.active');
});


//Client Paypal Routes
Route::middleware(['auth'])->group(function () {
    Route::get('/paypal/client-id', [PayPalController::class, 'getClientId'])
        ->name('paypal.client-id');
    Route::post('/orders/{order}/process-payment', [PayPalController::class, 'processPayment'])
        ->name('orders.process-payment');
    Route::post('/orders/{order}/create-paypal-order', [PayPalController::class, 'createOrder'])
        ->name('orders.create-paypal-order');
});


// Coupon routes for authenticated users
Route::middleware(['auth', 'verified'])->group(function () {
    Route::post('/validate-coupon', [OrdersController::class, 'validateCoupon'])->name('coupons.validate');
    Route::post('/suggest-coupon', [OrdersController::class, 'suggestCoupon'])->name('coupons.suggest');
    Route::get('/loyalty-coupons', [OrdersController::class, 'getLoyaltyCoupons'])->name('coupons.loyalty');
    Route::get('/seasonal-coupons', [OrdersController::class, 'getSeasonalCoupons'])->name('coupons.seasonal');
    Route::get('/first-order-coupon', [OrdersController::class, 'getFirstOrderCoupon'])->name('coupons.first-order');
    Route::get('/qualified-discounts', [OrdersController::class, 'getQualifiedDiscounts'])->name('coupons.qualified-discounts');
});



// Writer routes - consolidated and organized
Route::middleware(['auth', 'verified', 'writer'])->prefix('writer')->name('writer.')->group(function () {
    // Dashboard
    Route::get('/dashboard', [App\Http\Controllers\WriterController::class, 'dashboard'])->name('dashboard');

    // Orders and bids - only accessible after passing tests
    Route::get('/orders', [App\Http\Controllers\WriterController::class, 'availableOrders'])->name('orders');
    Route::get('/orders/{id}', [App\Http\Controllers\WriterController::class, 'show'])->name('orders.show');
    Route::post('/orders/{orderId}/bid', [App\Http\Controllers\WriterController::class, 'placeBid'])->name('orders.bid');
    
    // Assigned orders - orders currently assigned to the writer
    Route::get('/assignments', [App\Http\Controllers\WriterController::class, 'assignedOrders'])->name('assignments');

    // Order history - all orders assigned to the writer
    Route::get('/order-history', [App\Http\Controllers\WriterController::class, 'orderHistory'])->name('order-history');

    // Work submission routes
    Route::get('/orders/{order}/submit-work', [App\Http\Controllers\Writer\WorkSubmissionController::class, 'showSubmissionForm'])->name('orders.submit-work');
    Route::post('/orders/{order}/submit-work', [App\Http\Controllers\Writer\WorkSubmissionController::class, 'submitWork'])->name('orders.submit-work.store');
    Route::post('/orders/{order}/start-working', [App\Http\Controllers\Writer\WorkSubmissionController::class, 'startWorking'])->name('orders.start-working');

    // Bids management
    Route::get('/bids', [App\Http\Controllers\BidsController::class, 'index'])->name('bids');
    Route::post('/bids/{order}', [App\Http\Controllers\BidsController::class, 'store'])->name('bids.store');
    Route::get('/bids/{bid}', [App\Http\Controllers\BidsController::class, 'show'])->name('bids.show');
    Route::put('/bids/{bid}', [App\Http\Controllers\BidsController::class, 'update'])->name('bids.update');
    Route::delete('/bids/{bid}', [App\Http\Controllers\BidsController::class, 'destroy'])->name('bids.destroy');

    // Writer Test Routes
    Route::get('/test/instructions', [App\Http\Controllers\Writer\WriterTestController::class, 'instructions'])->name('test.instructions');
    Route::post('/test/start', [App\Http\Controllers\Writer\WriterTestController::class, 'start'])->name('test.start');
    Route::get('/test/take', [App\Http\Controllers\Writer\WriterTestController::class, 'take'])->name('test.take');
    Route::post('/test/submit', [App\Http\Controllers\Writer\WriterTestController::class, 'submit'])->name('test.submit');
    Route::get('/test/results', [App\Http\Controllers\Writer\WriterTestController::class, 'results'])->name('test.results');
    Route::post('/test/ping', [App\Http\Controllers\Writer\WriterTestController::class, 'recordActivity'])->name('test.ping');
    Route::post('/test/record-activity', [App\Http\Controllers\Writer\WriterTestController::class, 'recordActivity'])->name('test.record-activity');
    Route::get('/test/check-time', [App\Http\Controllers\Writer\WriterTestController::class, 'checkTime'])->name('test.check-time');
    Route::post('/test/auto-submit', [App\Http\Controllers\Writer\WriterTestController::class, 'autoSubmit'])->name('test.auto-submit');

    // Essay test routes
    Route::get('/essay/instructions', [App\Http\Controllers\Writer\WriterEssayController::class, 'instructions'])->name('essay.instructions');
    Route::post('/essay/start', [App\Http\Controllers\Writer\WriterEssayController::class, 'start'])->name('essay.start');
    Route::get('/essay/write', [App\Http\Controllers\Writer\WriterEssayController::class, 'write'])->name('essay.write');
    Route::post('/essay/upload-file', [App\Http\Controllers\Writer\WriterEssayController::class, 'uploadFile'])->name('essay.upload-file');
    Route::post('/essay/submit', [App\Http\Controllers\Writer\WriterEssayController::class, 'submit'])->name('essay.submit');
    Route::post('/essay/auto-submit', [App\Http\Controllers\Writer\WriterEssayController::class, 'autoSubmit'])->name('essay.auto-submit');
    Route::get('/essay/confirmation', [App\Http\Controllers\Writer\WriterEssayController::class, 'confirmation'])->name('essay.confirmation');
    Route::get('/essay/check-time', [App\Http\Controllers\Writer\WriterEssayController::class, 'checkTime'])->name('essay.check-time');
    Route::post('/essay/check-time', [App\Http\Controllers\Writer\WriterEssayController::class, 'checkTime']);

    // Writer Revision Management
    Route::get('/revisions', [App\Http\Controllers\Writer\WriterRevisionController::class, 'index'])->name('revisions.index');
    Route::get('/revisions/dashboard', [App\Http\Controllers\Writer\WriterRevisionController::class, 'dashboard'])->name('revisions.dashboard');
    Route::get('/revisions/{revision}', [App\Http\Controllers\Writer\WriterRevisionController::class, 'show'])->name('revisions.show');
    Route::post('/revisions/{revision}/start-working', [App\Http\Controllers\Writer\WriterRevisionController::class, 'startWorking'])->name('revisions.start-working');
    Route::post('/revisions/{revision}/mark-complete', [App\Http\Controllers\Writer\WriterRevisionController::class, 'markComplete'])->name('revisions.mark-complete');

    // Earnings Overview
    Route::get('/earnings', [App\Http\Controllers\WriterController::class, 'earnings'])->name('earnings');

    Route::get('/profile', [App\Http\Controllers\Writer\WriterProfileController::class, 'edit'])
        ->name('profile.edit');
    Route::patch('/profile', [App\Http\Controllers\Writer\WriterProfileController::class, 'update'])
        ->name('profile.update');
    Route::post('/profile/upload-image', [App\Http\Controllers\Writer\WriterProfileController::class, 'uploadProfileImage'])
        ->name('profile.upload-image');
});


/// Admin coupon management routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Default Coupon Management (must be before regular coupons resource)
    Route::resource('default-coupons', \App\Http\Controllers\Admin\DefaultCouponController::class);
    Route::put('default-coupons/{defaultCoupon}/toggle-status', [\App\Http\Controllers\Admin\DefaultCouponController::class, 'toggleStatus'])
        ->name('default-coupons.toggle-status');
    
    // Basic CRUD routes
    Route::resource('coupons', \App\Http\Controllers\Admin\CouponController::class);

    // Toggle coupon status
    Route::put('coupons/{coupon}/toggle-status', [\App\Http\Controllers\Admin\CouponController::class, 'toggleStatus'])
        ->name('coupons.toggle-status');

    // Bulk operations
    Route::put('coupons/bulk-toggle-status', [\App\Http\Controllers\Admin\CouponController::class, 'bulkToggleStatus'])
        ->name('coupons.bulk-toggle-status');
    Route::delete('coupons/bulk-delete', [\App\Http\Controllers\Admin\CouponController::class, 'bulkDelete'])
        ->name('coupons.bulk-delete');

    // Coupon statistics
    Route::get('coupons-statistics', [\App\Http\Controllers\Admin\CouponController::class, 'showStatistics'])
        ->name('coupons.statistics');

    // Coupon generation forms
    Route::get('coupons/generate/loyalty', [\App\Http\Controllers\Admin\CouponController::class, 'showGenerateLoyaltyCoupons'])
        ->name('coupons.generate.loyalty.form');
    Route::get('coupons/generate/seasonal', [\App\Http\Controllers\Admin\CouponController::class, 'showGenerateSeasonalCoupons'])
        ->name('coupons.generate.seasonal.form');
    Route::get('coupons/generate/flash', [\App\Http\Controllers\Admin\CouponController::class, 'showGenerateFlashCoupon'])
        ->name('coupons.generate.flash.form');
    Route::get('coupons/generate/first-order', [\App\Http\Controllers\Admin\CouponController::class, 'showGenerateFirstOrderCoupon'])
        ->name('coupons.generate.first-order.form');
    Route::get('coupons/generate/volume', [\App\Http\Controllers\Admin\CouponController::class, 'showGenerateVolumeCoupons'])
        ->name('coupons.generate.volume.form');
    Route::get('coupons/generate/referral', [\App\Http\Controllers\Admin\CouponController::class, 'showGenerateReferralCoupon'])
        ->name('coupons.generate.referral.form');
    Route::get('coupons/generate/anniversary', [\App\Http\Controllers\Admin\CouponController::class, 'showGenerateAnniversaryCoupon'])
        ->name('coupons.generate.anniversary.form');

    // Coupon generation handlers
    Route::post('coupons/generate/loyalty', [\App\Http\Controllers\Admin\CouponController::class, 'generateLoyaltyCoupons'])
        ->name('coupons.generate.loyalty');
    Route::post('coupons/generate/seasonal', [\App\Http\Controllers\Admin\CouponController::class, 'generateSeasonalCoupons'])
        ->name('coupons.generate.seasonal');
    Route::post('coupons/generate/flash', [\App\Http\Controllers\Admin\CouponController::class, 'generateFlashCoupon'])
        ->name('coupons.generate.flash');
    Route::post('coupons/generate/first-order', [\App\Http\Controllers\Admin\CouponController::class, 'generateFirstOrderCoupon'])
        ->name('coupons.generate.first-order');
    Route::post('coupons/generate/volume', [\App\Http\Controllers\Admin\CouponController::class, 'generateVolumeCoupons'])
        ->name('coupons.generate.volume');
    Route::post('coupons/generate/referral', [\App\Http\Controllers\Admin\CouponController::class, 'generateReferralCoupon'])
        ->name('coupons.generate.referral');
    Route::post('coupons/generate/anniversary', [\App\Http\Controllers\Admin\CouponController::class, 'generateAnniversaryCoupon'])
        ->name('coupons.generate.anniversary');
});

// Admin loyalty tier management routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Basic CRUD routes
    Route::resource('loyalty-tiers', \App\Http\Controllers\Admin\LoyaltyTierController::class);

    // Toggle loyalty tier status
    Route::put('loyalty-tiers/{loyaltyTier}/toggle-status', [\App\Http\Controllers\Admin\LoyaltyTierController::class, 'toggleStatus'])
        ->name('loyalty-tiers.toggle-status');

    // Bulk operations
    Route::put('loyalty-tiers/bulk-toggle-status', [\App\Http\Controllers\Admin\LoyaltyTierController::class, 'bulkToggleStatus'])
        ->name('loyalty-tiers.bulk-toggle-status');
    Route::delete('loyalty-tiers/bulk-delete', [\App\Http\Controllers\Admin\LoyaltyTierController::class, 'bulkDelete'])
        ->name('loyalty-tiers.bulk-delete');

    // Loyalty tier statistics
    Route::get('loyalty-tiers-statistics', [\App\Http\Controllers\Admin\LoyaltyTierController::class, 'showStatistics'])
        ->name('loyalty-tiers.statistics');
});

// Admin seasonal type management routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Basic CRUD routes
    Route::resource('seasonal-types', \App\Http\Controllers\Admin\SeasonalTypeController::class);

    // Toggle seasonal type status
    Route::post('seasonal-types/{seasonalType}/toggle-status', [\App\Http\Controllers\Admin\SeasonalTypeController::class, 'toggleStatus'])
        ->name('seasonal-types.toggle-status');

    // Bulk actions
    Route::post('seasonal-types/bulk-toggle-status', [\App\Http\Controllers\Admin\SeasonalTypeController::class, 'bulkToggleStatus'])
        ->name('seasonal-types.bulk-toggle-status');
    Route::delete('seasonal-types/bulk-delete', [\App\Http\Controllers\Admin\SeasonalTypeController::class, 'bulkDelete'])
        ->name('seasonal-types.bulk-delete');

    // Statistics
    Route::get('seasonal-types/statistics/show', [\App\Http\Controllers\Admin\SeasonalTypeController::class, 'showStatistics'])
        ->name('seasonal-types.statistics');
});




// Payment routes
Route::middleware(['auth', 'verified'])->group(function () {


    Route::get('/orders/{order}/payment', [PaymentController::class, 'showPaymentOptions'])
        ->name('orders.payment');
    Route::post('/orders/{order}/initialize-payment', [PaymentController::class, 'initializePayment'])
        ->name('orders.initialize-payment');
    Route::post('/orders/{order}/process-payment', [PaymentController::class, 'processPayment'])
        ->name('orders.process-payment');
    Route::get('/payment-config/{method}', [PaymentController::class, 'getPaymentConfig'])
        ->name('payment.config');
    Route::get('/payments/{payment}/status', [PaymentController::class, 'checkPaymentStatus'])
        ->name('payments.status');
    Route::get('/orders/{order}/payment-history', [PaymentController::class, 'showPaymentHistory'])
    ->name('orders.payment-history');

// PayPal Direct return and cancel routes
Route::get('/payments/paypal-direct/{order}/return', [App\Http\Controllers\Payments\PayPalDirectController::class, 'return'])
    ->name('payments.paypal-direct.return');
Route::get('/payments/paypal-direct/{order}/cancel', [App\Http\Controllers\Payments\PayPalDirectController::class, 'cancel'])
    ->name('payments.paypal-direct.cancel');
});




// Stripe routes
Route::middleware('auth', 'verified')->group(function () {});

Route::get('/stripe/publishable-key', [StripeController::class, 'getPublishableKey'])
    ->name('stripe.publishable-key');
Route::post('/orders/{order}/create-payment-intent', [StripeController::class, 'createPaymentIntent'])
    ->name('orders.create-payment-intent');
Route::post('/orders/{order}/process-stripe-payment', [StripeController::class, 'processPayment'])
    ->name('orders.process-stripe-payment');

// Stripe webhook - no CSRF protection needed
Route::post('webhooks/stripe', [StripeController::class, 'handleWebhook'])
    ->withoutMiddleware([\Illuminate\Foundation\Http\Middleware\VerifyCsrfToken::class])
    ->name('webhooks.stripe');
// Payment webhook routes - no CSRF protection needed
Route::post('webhooks/paypal', [PayPalWebhookController::class, 'handleWebhook'])
    ->withoutMiddleware([\Illuminate\Foundation\Http\Middleware\VerifyCsrfToken::class])
    ->name('webhooks.paypal');

// PayPal Direct IPN webhook - no CSRF protection needed
Route::post('webhooks/paypal-direct-ipn', [App\Http\Controllers\Webhooks\PayPalDirectIpnController::class, 'handle'])
    ->withoutMiddleware([\Illuminate\Foundation\Http\Middleware\VerifyCsrfToken::class])
    ->name('webhooks.paypal-direct.ipn');



//file management routes
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/files/{orderFile}/download', [OrderFilesController::class, 'download'])
        ->name('files.download')
        ->middleware('throttle:60,1'); // Rate limiting for downloads

    Route::delete('/files/{orderFile}', [OrderFilesController::class, 'destroy'])
        ->name('files.destroy')
        ->whereNumber('orderFile'); // Ensure orderFile is a number

    Route::post('/files/chunk', [OrderFilesController::class, 'storeChunk'])
        ->name('files.store-chunk')
        ->middleware(['throttle:120,1']); // Rate limiting for uploads
});


// Order file management routes
Route::middleware(['auth'])->group(function () {
    Route::post('/order-files/client-upload', [OrderFilesController::class, 'clientUpload'])->name('order-files.client-upload');
    Route::post('/order-files/writer-upload', [OrderFilesController::class, 'writerUpload'])->name('order-files.writer-upload');
    Route::get('/order-files/{orderId}', [OrderFilesController::class, 'getOrderFiles'])->name('order-files.get');
    Route::get('/files/{orderFile}/download', [OrderFilesController::class, 'download'])->name('files.download');
    Route::delete('/files/{orderFile}', [OrderFilesController::class, 'destroy'])->name('files.destroy');
    Route::post('/files/chunk', [OrderFilesController::class, 'storeChunk'])->name('files.chunk');
});

// Admin file upload route - protected by admin middleware
Route::middleware(['auth', 'admin'])->group(function () {
    Route::post('/order-files/admin-upload', [OrderFilesController::class, 'adminUpload'])->name('order-files.admin-upload');
});


// Writer routes - consolidated and organized
Route::middleware(['auth', 'verified', 'writer'])->prefix('writer')->name('writer.')->group(function () {
    // Dashboard
    Route::get('/dashboard', [App\Http\Controllers\WriterController::class, 'dashboard'])->name('dashboard');

    // Orders and bids - only accessible after passing tests
    Route::get('/orders', [App\Http\Controllers\WriterController::class, 'availableOrders'])->name('orders');
    Route::get('/orders/{id}', [App\Http\Controllers\WriterController::class, 'show'])->name('orders.show');
    Route::post('/orders/{orderId}/bid', [App\Http\Controllers\WriterController::class, 'placeBid'])->name('orders.bid');
    
    // Assigned orders - orders currently assigned to the writer
    Route::get('/assignments', [App\Http\Controllers\WriterController::class, 'assignedOrders'])->name('assignments');

    // Order history - all orders assigned to the writer
    Route::get('/order-history', [App\Http\Controllers\WriterController::class, 'orderHistory'])->name('order-history');

    // Work submission routes
    Route::get('/orders/{order}/submit-work', [App\Http\Controllers\Writer\WorkSubmissionController::class, 'showSubmissionForm'])->name('orders.submit-work');
    Route::post('/orders/{order}/submit-work', [App\Http\Controllers\Writer\WorkSubmissionController::class, 'submitWork'])->name('orders.submit-work.store');
    Route::post('/orders/{order}/start-working', [App\Http\Controllers\Writer\WorkSubmissionController::class, 'startWorking'])->name('orders.start-working');

    // Bids management
    Route::get('/bids', [App\Http\Controllers\BidsController::class, 'index'])->name('bids');
    Route::post('/bids/{order}', [App\Http\Controllers\BidsController::class, 'store'])->name('bids.store');
    Route::get('/bids/{bid}', [App\Http\Controllers\BidsController::class, 'show'])->name('bids.show');
    Route::put('/bids/{bid}', [App\Http\Controllers\BidsController::class, 'update'])->name('bids.update');
    Route::delete('/bids/{bid}', [App\Http\Controllers\BidsController::class, 'destroy'])->name('bids.destroy');

    // Writer Test Routes
    Route::get('/test/instructions', [App\Http\Controllers\Writer\WriterTestController::class, 'instructions'])->name('test.instructions');
    Route::post('/test/start', [App\Http\Controllers\Writer\WriterTestController::class, 'start'])->name('test.start');
    Route::get('/test/take', [App\Http\Controllers\Writer\WriterTestController::class, 'take'])->name('test.take');
    Route::post('/test/submit', [App\Http\Controllers\Writer\WriterTestController::class, 'submit'])->name('test.submit');
    Route::get('/test/results', [App\Http\Controllers\Writer\WriterTestController::class, 'results'])->name('test.results');
    Route::post('/test/ping', [App\Http\Controllers\Writer\WriterTestController::class, 'recordActivity'])->name('test.ping');
    Route::post('/test/record-activity', [App\Http\Controllers\Writer\WriterTestController::class, 'recordActivity'])->name('test.record-activity');
    Route::get('/test/check-time', [App\Http\Controllers\Writer\WriterTestController::class, 'checkTime'])->name('test.check-time');
    Route::post('/test/auto-submit', [App\Http\Controllers\Writer\WriterTestController::class, 'autoSubmit'])->name('test.auto-submit');

    // Essay test routes
    Route::get('/essay/instructions', [App\Http\Controllers\Writer\WriterEssayController::class, 'instructions'])->name('essay.instructions');
    Route::post('/essay/start', [App\Http\Controllers\Writer\WriterEssayController::class, 'start'])->name('essay.start');
    Route::get('/essay/write', [App\Http\Controllers\Writer\WriterEssayController::class, 'write'])->name('essay.write');
    Route::post('/essay/upload-file', [App\Http\Controllers\Writer\WriterEssayController::class, 'uploadFile'])->name('essay.upload-file');
    Route::post('/essay/submit', [App\Http\Controllers\Writer\WriterEssayController::class, 'submit'])->name('essay.submit');
    Route::post('/essay/auto-submit', [App\Http\Controllers\Writer\WriterEssayController::class, 'autoSubmit'])->name('essay.auto-submit');
    Route::get('/essay/confirmation', [App\Http\Controllers\Writer\WriterEssayController::class, 'confirmation'])->name('essay.confirmation');
    Route::get('/essay/check-time', [App\Http\Controllers\Writer\WriterEssayController::class, 'checkTime'])->name('essay.check-time');
    Route::post('/essay/check-time', [App\Http\Controllers\Writer\WriterEssayController::class, 'checkTime']);
});






//admin routes
Route::middleware(['auth', 'verified', 'admin'])->group(function () {
    Route::get('/admin/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    Route::get('/admin/users/{user}/orders', [AdminController::class, 'userOrders'])->name('admin.user-orders');
});


//admin academic level, subjects, urgencies & papertypes routes resources
Route::middleware(['auth',  'admin', 'verified'])->group(function () {
    Route::resource('academic-levels', AcademicLevelsController::class);
    Route::resource('subjects', SubjectsController::class)->except(['show']);
    Route::resource('paper-types', PaperTypesController::class)->except(['show']);
    Route::resource('pricings', UrgenciesController::class)->except(['show']);
    Route::resource('currencies', CurrencyController::class)->except(['show']);
    Route::post('/currencies/{currency}/toggle-status', [CurrencyController::class, 'toggleStatus'])->name('currencies.toggle-status');
});

//admin order routes
Route::middleware(['auth',  'admin', 'verified'])->group(function () {
    Route::get('/admin/orders', [AdminOrdersController::class, 'index'])->name('admin.orders.index');
    Route::get('/admin/orders/create', [AdminOrdersController::class, 'create'])->name('admin.orders.create');
    Route::get('/admin/orders/search', [AdminOrdersController::class, 'search'])->name('admin.orders.search');
    Route::get('/admin/orders/{order}', [AdminOrdersController::class, 'show'])->name('admin.orders.show');
    Route::get('/admin/orders/{order}/edit', [AdminOrdersController::class, 'edit'])->name('admin.orders.edit');
    Route::put('/admin/orders/{order}', [AdminOrdersController::class, 'update'])->name('admin.orders.update');
    Route::delete('/admin/orders/{order}', [AdminOrdersController::class, 'destroy'])->name('admin.orders.destroy');
    Route::post('/admin/orders', [AdminOrdersController::class, 'store'])->name('admin.orders.store');
    Route::post('/admin/orders/{id}/update-deadline', [AdminOrdersController::class, 'updateDeadline'])->middleware(['auth', 'admin']);
    Route::post('/admin/orders/{id}/update-writer-deadline', [AdminOrdersController::class, 'updateWriterDeadline'])->middleware(['auth', 'admin']);
    Route::post('/admin/orders/{id}/update-payment-status', [AdminOrdersController::class, 'updatePaymentStatus'])
        ->name('admin.orders.update-payment-status');
    Route::post('/admin/orders/{id}/update-order-status', [AdminOrdersController::class, 'updateOrderStatus'])
        ->name('admin.orders.update-order-status');
    Route::post('/coupon-validate', [AdminOrdersController::class, 'couponValidate'])
        ->name('admin.coupon.validate');
    
    // Order status management routes
    Route::put('/admin/orders/{order}/status', [App\Http\Controllers\Admin\OrderStatusController::class, 'changeStatus'])
        ->name('admin.orders.change-status');
    Route::post('/admin/orders/{order}/complete-review', [App\Http\Controllers\Admin\OrderStatusController::class, 'completeAdminReview'])
        ->name('admin.orders.complete-review');
    Route::post('/admin/orders/{order}/client-decision', [App\Http\Controllers\Admin\OrderStatusController::class, 'handleClientDecision'])
        ->name('admin.orders.client-decision');
    Route::get('/admin/orders/{order}/status-history', [App\Http\Controllers\Admin\OrderStatusController::class, 'getStatusHistory'])
        ->name('admin.orders.status-history');
    Route::post('/admin/orders/{order}/mark-under-review', [App\Http\Controllers\Admin\OrderStatusController::class, 'markAsUnderReview'])
        ->name('admin.orders.mark-under-review');
});



//admin settings routes
Route::middleware(['auth',  'admin', 'verified'])->group(function () {

    Route::get('/admin/settings/{id}', [AdminSettingController::class, 'show'])->name('admin.settings.show');
    Route::get('/admin/settings/{id}/edit', [AdminSettingController::class, 'edit'])->name('admin.settings.edit');
    Route::put('/admin/settings/{id}', [AdminSettingController::class, 'update'])->name('admin.settings.update');
    Route::patch('/{id}/deactivate-coupon', [AdminSettingController::class, 'deactivateCoupon'])->name('admin.settings.deactivate-coupon');
    Route::patch('/{id}/activate-coupon', [AdminSettingController::class, 'activateCoupon'])->name('admin.settings.activate-coupon');
    Route::patch('/{id}/deactivate-stripe', [AdminSettingController::class, 'deactivateStripe'])->name('admin.settings.deactivate-stripe');
    Route::patch('/{id}/activate-stripe', [AdminSettingController::class, 'activateStripe'])->name('admin.settings.activate-stripe');
});

//admin third party scripts routes
Route::middleware(['auth', 'admin', 'verified'])->group(function () {
    Route::get('/admin/third-party-scripts', [App\Http\Controllers\Admin\ThirdPartyScriptsController::class, 'index'])->name('admin.third-party-scripts.index');
    Route::put('/admin/third-party-scripts', [App\Http\Controllers\Admin\ThirdPartyScriptsController::class, 'update'])->name('admin.third-party-scripts.update');
});


//admin users routes
Route::middleware(['auth', 'admin', 'verified'])->prefix('admin/users')->group(function () {
    Route::get('/', [AdminUserController::class, 'index'])->name('admin.users.index');
    Route::get('/create', [AdminUserController::class, 'create'])->name('admin.users.create');
    Route::post('/', [AdminUserController::class, 'store'])->name('admin.users.store');
    Route::get('/search', [AdminUserController::class, 'search'])->name('admin.users.search');
    Route::get('/{id}', [AdminUserController::class, 'show'])->name('admin.users.show');
    Route::get('/{id}/edit', [AdminUserController::class, 'edit'])->name('admin.users.edit');
    Route::put('/{id}', [AdminUserController::class, 'update'])->name('admin.users.update');
    Route::patch('/{id}/deactivate', [AdminUserController::class, 'deactivate'])->name('admin.users.deactivate');
    Route::patch('/{id}/activate', [AdminUserController::class, 'activate'])->name('admin.users.activate');
    Route::delete('/{id}', [AdminUserController::class, 'destroy'])->name('admin.users.destroy');
});

// Admin Test Management Routes
Route::middleware(['auth', 'verified', 'admin'])->prefix('admin')->name('admin.')->group(function () {

    // Test Questions Management
    Route::resource('test-questions', TestQuestionController::class);
    Route::post('/test-questions/{question}/toggle-status', [App\Http\Controllers\Admin\TestQuestionController::class, 'toggleStatus'])->name('test-questions.toggle-status');

    // Essay Topics Management
    Route::resource('essay-topics', App\Http\Controllers\Admin\EssayTopicController::class);
    Route::post('/essay-topics/{topic}/toggle-status', [App\Http\Controllers\Admin\EssayTopicController::class, 'toggleStatus'])->name('essay-topics.toggle-status');

    // Writer Test Review
    Route::get('/writers/tests', [App\Http\Controllers\Admin\WriterTestReviewController::class, 'index'])->name('writers.tests');
    Route::get('/writers/tests/{id}', [App\Http\Controllers\Admin\WriterTestReviewController::class, 'show'])->name('writers.tests.show');

    // Essay review routes
    Route::get('/essays', [App\Http\Controllers\Admin\EssayReviewController::class, 'index'])->name('essays.index');
    Route::get('/essays/{id}', [App\Http\Controllers\Admin\EssayReviewController::class, 'show'])->name('essays.show');
    Route::post('/essays/{id}/review', [App\Http\Controllers\Admin\EssayReviewController::class, 'review'])->name('essays.review');
    Route::get('/essays/{id}/download', [App\Http\Controllers\Admin\EssayReviewController::class, 'download'])->name('essays.download');
});



// Admin Payment Management Routes
Route::middleware(['auth', 'verified', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Payment Methods Management
    Route::resource('payment-methods', App\Http\Controllers\Admin\PaymentMethodController::class);
    Route::post('payment-methods/{id}/toggle-status', [App\Http\Controllers\Admin\PaymentMethodController::class, 'toggleActive'])
        ->name('payment-methods.toggle-status');
    Route::post('payment-methods/{id}/test-connection', [App\Http\Controllers\Admin\PaymentMethodController::class, 'testConnection'])
        ->name('payment-methods.test-connection');

    // Payment Transactions Management
    Route::get('payments', [App\Http\Controllers\PaymentController::class, 'index'])->name('payments.index');
    Route::get('payments/pending', [App\Http\Controllers\PaymentController::class, 'pending'])->name('payments.pending');
    Route::get('payments/failed', [App\Http\Controllers\PaymentController::class, 'failed'])->name('payments.failed');
    Route::get('payments/{payment}', [App\Http\Controllers\PaymentController::class, 'show'])->name('payments.show');
    Route::post('payments/{payment}/update-status', [App\Http\Controllers\Admin\PaymentController::class, 'updateStatus'])
        ->name('payments.update-status');
});

// Admin Writer Withdrawal Management Routes
Route::middleware(['auth', 'verified', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Writer Withdrawal Management
    Route::get('writer-withdrawals', [App\Http\Controllers\Admin\WriterWithdrawalController::class, 'index'])
        ->name('writer-withdrawals.index');
    Route::get('writer-withdrawals/{withdrawal}', [App\Http\Controllers\Admin\WriterWithdrawalController::class, 'show'])
        ->name('writer-withdrawals.show');
    Route::post('writer-withdrawals/{withdrawal}/approve', [App\Http\Controllers\Admin\WriterWithdrawalController::class, 'approve'])
        ->name('writer-withdrawals.approve');
    Route::post('writer-withdrawals/{withdrawal}/reject', [App\Http\Controllers\Admin\WriterWithdrawalController::class, 'reject'])
        ->name('writer-withdrawals.reject');
    Route::post('writer-withdrawals/{withdrawal}/process', [App\Http\Controllers\Admin\WriterWithdrawalController::class, 'process'])
        ->name('writer-withdrawals.process');
    Route::post('writer-withdrawals/{withdrawal}/mark-paid', [App\Http\Controllers\Admin\WriterWithdrawalController::class, 'markAsPaid'])
        ->name('writer-withdrawals.mark-paid');
    Route::post('writer-withdrawals/bulk-approve', [App\Http\Controllers\Admin\WriterWithdrawalController::class, 'bulkApprove'])
        ->name('writer-withdrawals.bulk-approve');
    Route::get('writer-withdrawals-export', [App\Http\Controllers\Admin\WriterWithdrawalController::class, 'export'])
        ->name('writer-withdrawals.export');
});


// Notification routes
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications.index');
    // Add this with your other notification routes
    Route::get('/notifications/{id}', [NotificationController::class, 'show'])->name('notifications.show');

    Route::get('/notifications/api/list', [NotificationController::class, 'getNotifications'])->name('notifications.list');
    Route::get('/notifications/api/unread', [NotificationController::class, 'unread'])->name('notifications.unread');
    Route::get('/notifications/api/count', [NotificationController::class, 'count'])->name('notifications.count');
    Route::post('/notifications/api/{id}/read', [NotificationController::class, 'markAsRead'])->name('notifications.mark-read');
    Route::post('/notifications/api/read', [NotificationController::class, 'markMultipleAsRead'])->name('notifications.mark-multiple-read');
    Route::post('/notifications/api/read-all', [NotificationController::class, 'markAllAsRead'])->name('notifications.mark-all-read');
    Route::delete('/notifications/api/{id}', [NotificationController::class, 'delete'])->name('notifications.delete');
});

// Messaging routes
Route::middleware(['auth', 'verified'])->prefix('messaging')->name('messaging.')->group(function () {
    Route::get('/conversations', [App\Http\Controllers\Messaging\MessagingController::class, 'getConversations'])->name('conversations');
    Route::get('/conversations/{conversation}/messages', [App\Http\Controllers\Messaging\MessagingController::class, 'getMessages'])->name('messages');
    Route::post('/conversations/{conversation}/messages', [App\Http\Controllers\Messaging\MessagingController::class, 'sendMessage'])->name('send-message');
    Route::get('/unread-count', [App\Http\Controllers\Messaging\MessagingController::class, 'getUnreadCount'])->name('unread-count');
    Route::post('/conversations', [App\Http\Controllers\Messaging\MessagingController::class, 'createConversation'])->name('create-conversation');
    Route::get('/available-users', [App\Http\Controllers\Messaging\MessagingController::class, 'getAvailableUsers'])->name('available-users');
    
    // Status management routes
    Route::patch('/conversations/{conversation}/resolve', [App\Http\Controllers\Messaging\MessagingController::class, 'resolveConversation'])->name('resolve-conversation');
    Route::patch('/conversations/{conversation}/reopen', [App\Http\Controllers\Messaging\MessagingController::class, 'reopenConversation'])->name('reopen-conversation');
    Route::patch('/conversations/{conversation}/archive', [App\Http\Controllers\Messaging\MessagingController::class, 'archiveConversation'])->name('archive-conversation');
    Route::patch('/conversations/{conversation}/escalate', [App\Http\Controllers\Messaging\MessagingController::class, 'escalateConversation'])->name('escalate-conversation');
    
    // Bulk operations routes
    Route::post('/conversations/bulk-archive', [App\Http\Controllers\Messaging\MessagingController::class, 'bulkArchiveConversations'])->name('bulk-archive-conversations');
    Route::post('/conversations/bulk-resolve', [App\Http\Controllers\Messaging\MessagingController::class, 'bulkResolveConversations'])->name('bulk-resolve-conversations');
    
    // Analytics routes (admin only)
    Route::get('/analytics', [App\Http\Controllers\Messaging\MessagingAnalyticsController::class, 'index'])->name('analytics');
    Route::get('/analytics/export', [App\Http\Controllers\Messaging\MessagingAnalyticsController::class, 'export'])->name('analytics-export');
});



// Admin Payment Analytics Routes
Route::middleware(['auth', 'verified', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Add this to your existing admin routes
    Route::get('payment-analytics', [App\Http\Controllers\Admin\PaymentAnalyticsController::class, 'index'])
        ->name('payment.analytics');
});

// Admin Payment Management Routes
Route::middleware(['auth', 'verified', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Add these to your existing admin routes
    Route::get('payments', [App\Http\Controllers\Admin\PaymentHistoryController::class, 'index'])
        ->name('payments.history');
    Route::get('payments/{payment}', [App\Http\Controllers\Admin\PaymentHistoryController::class, 'show'])
        ->name('payments.show');
    Route::get('payments-export', [App\Http\Controllers\Admin\PaymentHistoryController::class, 'export'])
        ->name('payments.export');
});

// Admin Writer Fine/Penalty System Routes
Route::middleware(['auth', 'verified', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Progressive Discipline Management
    Route::get('progressive-discipline', [App\Http\Controllers\Admin\ProgressiveDisciplineController::class, 'index'])
        ->name('progressive-discipline.index');
    Route::get('progressive-discipline/{infraction}', [App\Http\Controllers\Admin\ProgressiveDisciplineController::class, 'show'])
        ->name('progressive-discipline.show');
    Route::post('progressive-discipline/{infraction}/review', [App\Http\Controllers\Admin\ProgressiveDisciplineController::class, 'review'])
        ->name('progressive-discipline.review');
    Route::post('progressive-discipline/{infraction}/escalate', [App\Http\Controllers\Admin\ProgressiveDisciplineController::class, 'escalate'])
        ->name('progressive-discipline.escalate');
    Route::post('progressive-discipline/{infraction}/appeal', [App\Http\Controllers\Admin\ProgressiveDisciplineController::class, 'handleAppeal'])
        ->name('progressive-discipline.appeal');
    Route::get('progressive-discipline/repeat-offenders', [App\Http\Controllers\Admin\ProgressiveDisciplineController::class, 'repeatOffenders'])
        ->name('progressive-discipline.repeat-offenders');
    Route::get('progressive-discipline/performance-plans', [App\Http\Controllers\Admin\ProgressiveDisciplineController::class, 'performancePlans'])
        ->name('progressive-discipline.performance-plans');
    Route::put('progressive-discipline/performance-plans/{writer}', [App\Http\Controllers\Admin\ProgressiveDisciplineController::class, 'updatePerformancePlan'])
        ->name('progressive-discipline.update-performance-plan');
    Route::get('progressive-discipline/export', [App\Http\Controllers\Admin\ProgressiveDisciplineController::class, 'export'])
        ->name('progressive-discipline.export');

    // Fine Configuration Management
    Route::get('fine-configuration', [App\Http\Controllers\Admin\FineConfigurationController::class, 'index'])
        ->name('fine-configuration.index');
    Route::post('fine-configuration', [App\Http\Controllers\Admin\FineConfigurationController::class, 'update'])
        ->name('fine-configuration.update');
    Route::post('fine-configuration/reset', [App\Http\Controllers\Admin\FineConfigurationController::class, 'resetToDefaults'])
        ->name('fine-configuration.reset');
    Route::get('fine-configuration/statistics', [App\Http\Controllers\Admin\FineConfigurationController::class, 'statistics'])
        ->name('fine-configuration.statistics');
    Route::get('fine-configuration/export', [App\Http\Controllers\Admin\FineConfigurationController::class, 'export'])
        ->name('fine-configuration.export');
    Route::get('fine-configuration/api', [App\Http\Controllers\Admin\FineConfigurationController::class, 'api'])
        ->name('fine-configuration.api');

    // Writer Infraction Management
    Route::resource('writer-infractions', App\Http\Controllers\Admin\WriterInfractionController::class);
    Route::post('writer-infractions/{infraction}/change-status', [App\Http\Controllers\Admin\WriterInfractionController::class, 'changeStatus'])
        ->name('writer-infractions.change-status');
    Route::get('writer-infractions/export', [App\Http\Controllers\Admin\WriterInfractionController::class, 'export'])
        ->name('writer-infractions.export');
    Route::get('writer-infractions/statistics', [App\Http\Controllers\Admin\WriterInfractionController::class, 'statistics'])
        ->name('writer-infractions.statistics');

    // Writer Fine Management
    Route::resource('writer-fines', App\Http\Controllers\Admin\WriterFineController::class);
    Route::post('writer-fines/{fine}/change-status', [App\Http\Controllers\Admin\WriterFineController::class, 'changeStatus'])
        ->name('writer-fines.change-status');
    Route::post('writer-fines/{fine}/apply-to-payment', [App\Http\Controllers\Admin\WriterFineController::class, 'applyToPayment'])
        ->name('writer-fines.apply-to-payment');
    Route::get('writer-fines/export', [App\Http\Controllers\Admin\WriterFineController::class, 'export'])
        ->name('writer-fines.export');
    Route::get('writer-fines/statistics', [App\Http\Controllers\Admin\WriterFineController::class, 'statistics'])
        ->name('writer-fines.statistics');

    // Order Revision Management
    Route::get('revisions/dashboard', [App\Http\Controllers\Admin\OrderRevisionController::class, 'dashboard'])
        ->name('revisions.dashboard');
    Route::resource('revisions', App\Http\Controllers\Admin\OrderRevisionController::class);
    Route::post('revisions/client-request', [App\Http\Controllers\Admin\OrderRevisionController::class, 'clientRevisionRequest'])
        ->name('revisions.client-request');
    Route::post('revisions/{revision}/assign-writer', [App\Http\Controllers\Admin\OrderRevisionController::class, 'assignWriter'])
        ->name('revisions.assign-writer');
    Route::post('revisions/{revision}/escalate', [App\Http\Controllers\Admin\OrderRevisionController::class, 'escalate'])
        ->name('revisions.escalate');
    Route::post('revisions/{revision}/assess-quality', [App\Http\Controllers\Admin\OrderRevisionController::class, 'assessQuality'])
        ->name('revisions.assess-quality');
    Route::post('revisions/{revision}/reject', [App\Http\Controllers\Admin\OrderRevisionController::class, 'reject'])
        ->name('revisions.reject');

    // Payment Impact Management
    Route::get('payment-impacts', [App\Http\Controllers\Admin\PaymentImpactController::class, 'index'])
        ->name('payment-impacts.index');
    Route::get('payment-impacts/settings', [App\Http\Controllers\Admin\PaymentImpactController::class, 'settings'])
        ->name('payment-impacts.settings');
    Route::put('payment-impacts/settings', [App\Http\Controllers\Admin\PaymentImpactController::class, 'updateSettings'])
        ->name('payment-impacts.update-settings');
    Route::post('payment-impacts/{revision}/assess-quality', [App\Http\Controllers\Admin\PaymentImpactController::class, 'assessQuality'])
        ->name('payment-impacts.assess-quality');
    Route::post('payment-impacts/{revision}/reject', [App\Http\Controllers\Admin\PaymentImpactController::class, 'rejectRevision'])
        ->name('payment-impacts.reject');
    Route::get('payment-impacts/writer/{writerId}', [App\Http\Controllers\Admin\PaymentImpactController::class, 'writerAnalysis'])
        ->name('payment-impacts.writer-analysis');
    Route::get('payment-impacts/order/{orderId}', [App\Http\Controllers\Admin\PaymentImpactController::class, 'orderAnalysis'])
        ->name('payment-impacts.order-analysis');
    Route::post('payment-impacts/order/{orderId}/recalculate', [App\Http\Controllers\Admin\PaymentImpactController::class, 'recalculateOrder'])
        ->name('payment-impacts.recalculate-order');
});

// Admin Refund Routes
Route::middleware(['auth', 'verified', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::post('payments/{payment}/refund', [App\Http\Controllers\Admin\RefundController::class, 'process'])
        ->name('payments.refund');
    Route::get('payments/{payment}/refund-history', [App\Http\Controllers\Admin\RefundController::class, 'history'])
        ->name('payments.refund-history');
});

// Order-specific authentication routes (for preserving order context)
Route::middleware('guest')->prefix('order')->name('order.auth.')->group(function () {
    Route::get('login', [App\Http\Controllers\Auth\OrderAuthenticatedSessionController::class, 'create'])
        ->name('login');
    Route::post('login', [App\Http\Controllers\Auth\OrderAuthenticatedSessionController::class, 'store'])
        ->name('login.store');
    Route::get('register', [App\Http\Controllers\Auth\OrderRegisteredUserController::class, 'create'])
        ->name('register');
    Route::post('register', [App\Http\Controllers\Auth\OrderRegisteredUserController::class, 'store'])
        ->name('register.store');
});

// Writer Payment Management Routes
Route::middleware(['auth'])->prefix('writer/payment')->name('writer.payment.')->group(function () {
    // API routes for payment data
    Route::get('/summary', [App\Http\Controllers\WriterPaymentController::class, 'getSummary'])
        ->name('summary');
    Route::get('/pending-orders', [App\Http\Controllers\WriterPaymentController::class, 'getPendingOrders'])
        ->name('pending.orders');
    Route::get('/available-orders', [App\Http\Controllers\WriterPaymentController::class, 'getAvailableOrders'])
        ->name('available.orders');
    Route::get('/withdrawal-eligibility', [App\Http\Controllers\WriterPaymentController::class, 'checkWithdrawalEligibility'])
        ->name('withdrawal.eligibility');
    Route::get('/withdrawal-requests', [App\Http\Controllers\WriterPaymentController::class, 'getWithdrawalRequests'])
        ->name('withdrawal.requests');
    
    // Page routes
    Route::get('/dashboard', [App\Http\Controllers\WriterPaymentController::class, 'dashboard'])
        ->name('dashboard');
    Route::get('/pending', [App\Http\Controllers\WriterPaymentController::class, 'showPendingOrders'])
        ->name('pending');
    Route::get('/available', [App\Http\Controllers\WriterPaymentController::class, 'showAvailableOrders'])
        ->name('available');
    
    // Actions
    Route::post('/withdrawal-request', [App\Http\Controllers\WriterPaymentController::class, 'createWithdrawalRequest'])
        ->name('withdrawal.create');
});

// Writer Payment Routes (for the main navigation)
Route::middleware(['auth', 'verified', 'writer'])->prefix('writer')->name('writer.')->group(function () {
    // Payment History
    Route::get('/payments', [App\Http\Controllers\WriterPaymentController::class, 'paymentHistory'])
        ->name('payments');
    
    // Payment Methods
    Route::get('/payment-methods', [App\Http\Controllers\WriterPaymentController::class, 'paymentMethods'])
        ->name('payment-methods');
    Route::post('/payment-methods', [App\Http\Controllers\WriterPaymentController::class, 'storePaymentMethod'])
        ->name('payment-methods.store');
    Route::put('/payment-methods/{account}', [App\Http\Controllers\WriterPaymentController::class, 'updatePaymentMethod'])
        ->name('payment-methods.update');
    Route::delete('/payment-methods/{account}', [App\Http\Controllers\WriterPaymentController::class, 'deletePaymentMethod'])
        ->name('payment-methods.delete');
    Route::post('/payment-methods/{account}/set-primary', [App\Http\Controllers\WriterPaymentController::class, 'setPrimaryPaymentMethod'])
        ->name('payment-methods.set-primary');
});

// Urgent Orders API Routes (for web application)
Route::middleware(['auth', 'verified'])->prefix('urgent-orders')->name('urgent-orders.')->group(function () {
    Route::get('/', [App\Http\Controllers\Api\UrgentOrdersController::class, 'index'])->name('index');
    Route::get('/counts', [App\Http\Controllers\Api\UrgentOrdersController::class, 'counts'])->name('counts');
    Route::get('/filter-options', [App\Http\Controllers\Api\UrgentOrdersController::class, 'filterOptions'])->name('filter-options');
});

// Pricing Data API Route (public, no authentication required)
Route::get('/api/pricing-data', [App\Http\Controllers\Api\PricingDataController::class, 'index'])->name('api.pricing-data');

// Admin CMS Routes
Route::middleware(['auth', 'verified', 'admin'])->prefix('admin/cms')->name('admin.cms.')->group(function () {
    // Page Management Routes
    Route::get('/pages', [App\Http\Controllers\Admin\PageController::class, 'index'])->name('pages.index');
    Route::get('/pages/create', [App\Http\Controllers\Admin\PageController::class, 'create'])->name('pages.create');
    Route::post('/pages', [App\Http\Controllers\Admin\PageController::class, 'store'])->name('pages.store');
    Route::get('/pages/{page}', [App\Http\Controllers\Admin\PageController::class, 'show'])->name('pages.show');
    Route::get('/pages/{page}/edit', [App\Http\Controllers\Admin\PageController::class, 'edit'])->name('pages.edit');
    Route::put('/pages/{page}', [App\Http\Controllers\Admin\PageController::class, 'update'])->name('pages.update');
    Route::delete('/pages/{page}', [App\Http\Controllers\Admin\PageController::class, 'destroy'])->name('pages.destroy');
    
    // Page Actions
    Route::post('/pages/{page}/duplicate', [App\Http\Controllers\Admin\PageController::class, 'duplicate'])->name('pages.duplicate');
    Route::post('/pages/{page}/toggle-status', [App\Http\Controllers\Admin\PageController::class, 'toggleStatus'])->name('pages.toggle-status');
    
    // API Routes for Frontend
    Route::get('/api/pages/{slug}/content', [App\Http\Controllers\Admin\PageController::class, 'getPageContent'])->name('api.pages.content');

    // Convenience editors by slug
    Route::get('/pages/slug/affordable-essay-writing/edit', [App\Http\Controllers\Admin\PageController::class, 'editBySlug'])->name('pages.edit.affordable');
    // Dedicated affordable editor
    Route::get('/services/affordable/edit', [App\Http\Controllers\Admin\PageController::class, 'editAffordable'])->name('services.affordable.edit');
    // Dedicated buy and cheap editors
    Route::get('/services/buy/edit', [App\Http\Controllers\Admin\PageController::class, 'editBuy'])->name('services.buy.edit');
    Route::get('/services/cheap/edit', [App\Http\Controllers\Admin\PageController::class, 'editCheap'])->name('services.cheap.edit');
    
    // Content Block Management Routes
    Route::get('/content-blocks', [App\Http\Controllers\Admin\PageContentController::class, 'index'])->name('content-blocks.index');
    Route::post('/content-blocks', [App\Http\Controllers\Admin\PageContentController::class, 'store'])->name('content-blocks.store');
    Route::get('/content-blocks/{contentBlock}', [App\Http\Controllers\Admin\PageContentController::class, 'show'])->name('content-blocks.show');
    Route::put('/content-blocks/{contentBlock}', [App\Http\Controllers\Admin\PageContentController::class, 'update'])->name('content-blocks.update');
    Route::delete('/content-blocks/{contentBlock}', [App\Http\Controllers\Admin\PageContentController::class, 'destroy'])->name('content-blocks.destroy');
    
    // Content Block Actions
    Route::post('/content-blocks/{contentBlock}/toggle', [App\Http\Controllers\Admin\PageContentController::class, 'toggle'])->name('content-blocks.toggle');
    Route::post('/content-blocks/reorder', [App\Http\Controllers\Admin\PageContentController::class, 'reorder'])->name('content-blocks.reorder');
    
    // SEO Management Routes
    Route::get('/seo/{page}', [App\Http\Controllers\Admin\PageSeoController::class, 'show'])->name('seo.show');
    Route::put('/seo/{page}', [App\Http\Controllers\Admin\PageSeoController::class, 'update'])->name('seo.update');
    Route::post('/seo/{page}/generate', [App\Http\Controllers\Admin\PageSeoController::class, 'generate'])->name('seo.generate');
    Route::get('/seo/{page}/suggestions', [App\Http\Controllers\Admin\PageSeoController::class, 'suggestions'])->name('seo.suggestions');
    
    // SEO Image Upload
    Route::post('/seo/upload-image', [App\Http\Controllers\Admin\PageController::class, 'uploadSeoImage'])->name('seo.upload-image');
    
    // Media Management Routes
    Route::get('/media', [App\Http\Controllers\Admin\PageMediaController::class, 'index'])->name('media.index');
    Route::post('/media', [App\Http\Controllers\Admin\PageMediaController::class, 'store'])->name('media.store');
    Route::get('/media/{media}', [App\Http\Controllers\Admin\PageMediaController::class, 'show'])->name('media.show');
    Route::put('/media/{media}', [App\Http\Controllers\Admin\PageMediaController::class, 'update'])->name('media.update');
    Route::delete('/media/{media}', [App\Http\Controllers\Admin\PageMediaController::class, 'destroy'])->name('media.destroy');
    
    // Media Actions
    Route::post('/media/bulk-delete', [App\Http\Controllers\Admin\PageMediaController::class, 'bulkDelete'])->name('media.bulk-delete');
    Route::post('/media/optimize', [App\Http\Controllers\Admin\PageMediaController::class, 'optimize'])->name('media.optimize');
    Route::get('/media/stats', [App\Http\Controllers\Admin\PageMediaController::class, 'stats'])->name('media.stats');
    Route::get('/media/optimized-url', [App\Http\Controllers\Admin\PageMediaController::class, 'getOptimizedUrl'])->name('media.optimized-url');
    
    // Footer Management Routes
    Route::get('/footer', [App\Http\Controllers\Admin\FooterController::class, 'index'])->name('footer.index');
    Route::get('/footer/create', [App\Http\Controllers\Admin\FooterController::class, 'create'])->name('footer.create');
    Route::post('/footer', [App\Http\Controllers\Admin\FooterController::class, 'store'])->name('footer.store');
    Route::get('/footer/{footer}', [App\Http\Controllers\Admin\FooterController::class, 'show'])->name('footer.show');
    Route::get('/footer/{footer}/edit', [App\Http\Controllers\Admin\FooterController::class, 'edit'])->name('footer.edit');
    Route::put('/footer/{footer}', [App\Http\Controllers\Admin\FooterController::class, 'update'])->name('footer.update');
    Route::delete('/footer/{footer}', [App\Http\Controllers\Admin\FooterController::class, 'destroy'])->name('footer.destroy');
    
    // Footer Actions
    Route::post('/footer/update-order', [App\Http\Controllers\Admin\FooterController::class, 'updateOrder'])->name('footer.update-order');
    Route::post('/footer/{footer}/toggle-active', [App\Http\Controllers\Admin\FooterController::class, 'toggleActive'])->name('footer.toggle-active');
});

require __DIR__ . '/auth.php';
