<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" x-data="{ darkMode: localStorage.getItem('theme') === 'dark' }" :class="{ 'dark': darkMode }">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <!-- Theme and Mobile -->
    <meta name="theme-color" content="#1e40af">
    <meta name="msapplication-TileColor" content="#1e40af">
    <meta name="application-name" content="Academic Scribe">

    <title inertia><?php echo e(config('app.name', 'Academic Scribe')); ?></title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?php echo e(asset('images/favicon.png')); ?>">

    <!-- Preconnect for Performance -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

    <!-- Scripts -->
  <?php echo app('Tighten\Ziggy\BladeRouteGenerator')->generate(); ?>
  <?php echo app('Illuminate\Foundation\Vite')->reactRefresh(); ?>
  
  <?php if(app()->environment('local') || app()->environment('development') || config('app.debug')): ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.jsx', "resources/js/Pages/{$page['component']}.jsx"]); ?>
  <?php else: ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.jsx']); ?>
  <?php endif; ?>
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->head; } ?>

    <script>
        // Immediately set the theme based on localStorage or system preference
        (function() {
            const savedTheme = localStorage.getItem('theme');
            if (savedTheme === 'dark' || (!savedTheme && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        })();

    </script>
</head>
<body class="font-sans bg-slate-100 text-slate-900 dark:bg-slate-700 dark:text-white antialiased hold-transition sidebar-mini">
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->body; } else { ?><div id="app" data-page="<?php echo e(json_encode($page)); ?>"></div><?php } ?>

    <?php
        // Fetch third-party script settings from database
        $settings = \App\Models\AdminSetting::first();
    ?>

    <?php if($settings && $settings->enable_gtm && $settings->gtm_id): ?>
    <!-- Google Tag Manager - MANAGED FROM ADMIN PANEL -->
    <script>
      // Defer GTM loading until after page is interactive to improve LCP
      window.addEventListener('load', function() {
        setTimeout(function() {
          // Create and inject GTM script
          var gtagScript = document.createElement('script');
          gtagScript.async = true;
          gtagScript.src = 'https://www.googletagmanager.com/gtag/js?id=<?php echo e($settings->gtm_id); ?>';
          document.head.appendChild(gtagScript);
          
          // Initialize GTM when script loads
          gtagScript.onload = function() {
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());
            gtag('config', '<?php echo e($settings->gtm_id); ?>');
          };
        }, <?php echo e($settings->gtm_delay ?? 2000); ?>); // Customizable delay from admin
      });
    </script>
    <?php endif; ?>

    <?php if($settings && $settings->enable_tawkto && $settings->tawkto_property_id && $settings->tawkto_widget_id): ?>
    <!-- Tawk.to Chat - MANAGED FROM ADMIN PANEL -->
    <script>
      // Strategy: Delay Tawk.to loading until user interaction or after page load
      var tawkLoaded = false;
      
      function loadTawkTo() {
        if (tawkLoaded) return;
        tawkLoaded = true;
        
        var Tawk_API = Tawk_API || {}, Tawk_LoadStart = new Date();
        (function() {
          var s1 = document.createElement("script");
          s1.async = true;
          s1.src = 'https://embed.tawk.to/<?php echo e($settings->tawkto_property_id); ?>/<?php echo e($settings->tawkto_widget_id); ?>';
          s1.charset = 'UTF-8';
          s1.setAttribute('crossorigin', '*');
          document.body.appendChild(s1);
        })();
      }
      
      // Load Tawk.to after page is fully loaded (customizable delay)
      window.addEventListener('load', function() {
        setTimeout(loadTawkTo, <?php echo e($settings->tawkto_delay ?? 5000); ?>);
      });
      
      // OR load immediately on user interaction (mousemove, scroll, touch)
      var interactionEvents = ['mousemove', 'scroll', 'touchstart', 'keydown'];
      interactionEvents.forEach(function(event) {
        document.addEventListener(event, loadTawkTo, { once: true, passive: true });
      });
    </script>
    <?php endif; ?>

    <?php if($settings && $settings->enable_comm100 && $settings->comm100_site_id && $settings->comm100_code_plan && $settings->comm100_div_id): ?>
    <!-- Comm100 Live Chat - MANAGED FROM ADMIN PANEL -->
    <!-- Note: CORS errors in development (localhost) are expected - widget works in production -->
    <div id="<?php echo e($settings->comm100_div_id); ?>"></div>
    <script>
      // Initialize Comm100API immediately so the div can be found
      var Comm100API = Comm100API || {};
      (function(t) {
        // Set up the API configuration immediately
        t.chat_buttons = t.chat_buttons || [];
        t.chat_buttons.push({
          code_plan: "<?php echo e($settings->comm100_code_plan); ?>",
          div_id: "<?php echo e($settings->comm100_div_id); ?>"
        });
        t.site_id = <?php echo e($settings->comm100_site_id); ?>;
        t.main_code_plan = "<?php echo e($settings->comm100_code_plan); ?>";
        
        // Function to load the actual script (delayed for performance)
        function e(e) {
          var a = document.createElement("script");
          var c = document.getElementsByTagName("script")[0];
          a.type = "text/javascript";
          a.async = true;
          a.src = e + t.site_id;
          c.parentNode.insertBefore(a, c);
        }
        
        // Strategy: Delay Comm100 script loading until user interaction or after page load (optimized for performance)
        var comm100Loaded = false;
        
        function loadComm100() {
          if (comm100Loaded) return;
          comm100Loaded = true;
          
          // Load the main script
          e("https://vue.comm100.com/livechat.ashx?siteId=");
          
          // Fallback to standby server after 5 seconds if main server doesn't load
          setTimeout(function() {
            if (!t.loaded) {
              e("https://standby.comm100vue.com/livechat.ashx?siteId=");
            }
          }, 5000);
        }
        
        // Load Comm100 after page is fully loaded (customizable delay)
        window.addEventListener('load', function() {
          setTimeout(loadComm100, <?php echo e($settings->comm100_delay ?? 5000); ?>);
        });
        
        // OR load immediately on user interaction (mousemove, scroll, touch)
        var interactionEvents = ['mousemove', 'scroll', 'touchstart', 'keydown'];
        interactionEvents.forEach(function(event) {
          document.addEventListener(event, loadComm100, { once: true, passive: true });
        });
      })(Comm100API || {});
    </script>
    <?php endif; ?>
    
</body>
</html>
<?php /**PATH /home/beenie/Documents/academic-scribe/resources/views/app.blade.php ENDPATH**/ ?>