<?php

namespace Tests;

use Tests\TestCase;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;

class OrderFormTest extends TestCase
{
    use RefreshDatabase;

    public function test_order_context_storage()
    {
        $response = $this->postJson('/store-order-context', [
            'orderData' => ['title' => 'Test Essay'],
            'currentStep' => 2
        ]);

        $response->assertStatus(200)
                ->assertJson(['success' => true]);
    }

    public function test_order_login_redirect()
    {
        $user = User::factory()->create([
            'email' => 'test@example.com',
            'password' => bcrypt('password')
        ]);

        $this->postJson('/store-order-context', [
            'orderData' => ['title' => 'Test'],
            'currentStep' => 2
        ]);

        $response = $this->post('/order/login', [
            'email' => 'test@example.com',
            'password' => 'password'
        ]);

        $response->assertRedirect('/place-order');
    }

    public function test_order_register_flow()
    {
        $userData = [
            'name' => 'Test User',
            'email' => 'newuser@example.com',
            'password' => 'password',
            'password_confirmation' => 'password'
        ];

        $this->postJson('/store-order-context', [
            'orderData' => ['title' => 'Test'],
            'currentStep' => 2
        ]);

        $response = $this->post('/order/register', $userData);

        $response->assertRedirect('/place-order');
        
        $this->assertDatabaseHas('users', [
            'email' => 'newuser@example.com',
            'user_type' => 'client'
        ]);
    }
} 